<?php
define('BOT_TOKEN', '8577479007:AAHD6_QHOOWqVOdNqmuv_knqe3O55Q-6YDo');
define('ADMIN_IDS', ['8591561825','8139596280','8198454441']); // آیدی‌های ادمین

// پوشه‌های سیستمی که نباید در لیست نمایش داده شوند
define('SYSTEM_FOLDERS', ['SaEeDRat', 'data', 'deleted_ports', 'kon']);

function bot($method, $data = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => ["Content-Type: multipart/form-data"]
    ]);
    $result = curl_exec($ch);
    if(curl_error($ch)) {
        file_put_contents('curl_errors.log', curl_error($ch)."\n", FILE_APPEND);
    }
    curl_close($ch);
    return json_decode($result, true);
}

// تابع انتقال پوشه
function moveFolder($source, $destination) {
    if (!file_exists($source)) return false;
    
    if (!file_exists($destination)) {
        mkdir($destination, 0777, true);
    }
    
    $dir = opendir($source);
    while (($file = readdir($dir)) !== false) {
        if ($file != "." && $file != "..") {
            $src = $source . "/" . $file;
            $dst = $destination . "/" . $file;
            if (is_dir($src)) {
                moveFolder($src, $dst);
            } else {
                rename($src, $dst);
            }
        }
    }
    closedir($dir);
    return rmdir($source);
}

// تابع بازیابی پوشه
function restoreFolder($source, $destination) {
    return moveFolder($source, $destination);
}

// تابع کپی فایل
function copyFileToAllFolders($source_file, $target_filename) {
    $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
    $success_count = 0;
    $total_count = 0;
    
    foreach ($folders as $folder) {
        $folder_name = basename($folder);
        if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
            $target_path = $folder . '/' . $target_filename;
            if (copy($source_file, $target_path)) {
                $success_count++;
            }
            $total_count++;
        }
    }
    
    return ['success' => $success_count, 'total' => $total_count];
}

// تابع افزودن فایل جدید به تمام پوشه‌ها
function addNewFileToAllFolders($source_file, $target_filename) {
    $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
    $success_count = 0;
    $total_count = 0;
    
    foreach ($folders as $folder) {
        $folder_name = basename($folder);
        if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
            $target_path = $folder . '/' . $target_filename;
            if (copy($source_file, $target_path)) {
                $success_count++;
            }
            $total_count++;
        }
    }
    
    return ['success' => $success_count, 'total' => $total_count];
}

// تابع به‌روزرسانی زمان تمام پورت‌ها به 30 روز
function updateAllPortsTo30Days() {
    $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
    $success_count = 0;
    $total_count = 0;
    
    foreach ($folders as $folder) {
        $folder_name = basename($folder);
        if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
            // به‌روزرسانی فایل chalim.php
            $chal_file = "$folder/chalim.php";
            if (file_exists($chal_file)) {
                $code = file_get_contents($chal_file);
                $code = preg_replace('/\$days_remaining\s*=\s*\d+;/', '$days_remaining = 30;', $code);
                file_put_contents($chal_file, $code);
            }
            
            // به‌روزرسانی یا ایجاد فایل time_data.json
            $time_data_dir = "$folder/data";
            if (!file_exists($time_data_dir)) {
                mkdir($time_data_dir, 0777, true);
            }
            
            $current_date = date('Y/m/d');
            $expiry_date = date('Y/m/d', strtotime("+30 days"));
            
            $time_data = [
                'purchase_date' => $current_date,
                'expiry_date' => $expiry_date,
                'days_remaining' => 30,
                'last_update' => $current_date
            ];
            
            file_put_contents("$time_data_dir/time_data.json", json_encode($time_data));
            
            // انتقال فایل time_seconds.json اگر وجود دارد
            $time_seconds_file = "$time_data_dir/time_seconds.json";
            if (file_exists($time_seconds_file)) {
                $public_html_time_dir = __DIR__ . "/public_html/time";
                if (!file_exists($public_html_time_dir)) {
                    mkdir($public_html_time_dir, 0777, true);
                }
                rename($time_seconds_file, "$public_html_time_dir/{$folder_name}_time_seconds.json");
            }
            
            $success_count++;
            $total_count++;
        }
    }
    
    return ['success' => $success_count, 'total' => $total_count];
}

// تابع آپدیت توکن همه پورت‌ها
function updateAllTokens($new_token) {
    $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
    $success_count = 0;
    $total_count = 0;
    
    foreach ($folders as $folder) {
        $folder_name = basename($folder);
        if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
            // به‌روزرسانی فایل chalim.php
            $chal_file = "$folder/chalim.php";
            if (file_exists($chal_file)) {
                $code = file_get_contents($chal_file);
                $code = preg_replace('/\$bot_token\s*=\s*".*?";/', '$bot_token = "' . $new_token . '";', $code);
                file_put_contents($chal_file, $code);
                $success_count++;
            }
            $total_count++;
        }
    }
    
    return ['success' => $success_count, 'total' => $total_count];
}

$update = json_decode(file_get_contents("php://input"), true);
if (!$update) {
    exit;
}

// مدیریت callback_query
if (isset($update['callback_query'])) {
    $callback = $update['callback_query'];
    $data = $callback['data'];
    $chat_id = $callback['from']['id'];
    $message_id = $callback['message']['message_id'];

    if (in_array($chat_id, ADMIN_IDS)) {
        // مدیریت منوی اصلی
        if ($data == 'create_new_bot') {
            $step_file = __DIR__ . "/step_$chat_id.txt";
            file_put_contents($step_file, "await_token");
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "لطفاً توکن ربات جدید را ارسال کنید:"
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        elseif ($data == 'delete_bot') {
            // نمایش لیست پوشه‌ها برای حذف
            $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
            $folders_list = [];
            
            foreach ($folders as $folder) {
                $folder_name = basename($folder);
                if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
                    $folders_list[] = $folder_name;
                }
            }
            
            if (empty($folders_list)) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ هیچ پورتی برای حذف وجود ندارد."
                ]);
                exit;
            }
            
            $keyboard = ['inline_keyboard' => []];
            foreach ($folders_list as $folder) {
                $keyboard['inline_keyboard'][] = [
                    ['text' => "📁 $folder", 'callback_data' => "delete_folder_$folder"]
                ];
            }
            $keyboard['inline_keyboard'][] = [
                ['text' => "🔙 بازگشت", 'callback_data' => "main_menu"]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📋 لیست پورت‌ها:\nلطفاً پورتی که می‌خواهید حذف کنید را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        elseif ($data == 'renew_bot') {
            // نمایش لیست پوشه‌های حذف شده برای تمدید
            $deleted_dir = __DIR__ . "/deleted_ports";
            $folders_list = [];
            
            if (file_exists($deleted_dir)) {
                $folders = glob($deleted_dir . '/*', GLOB_ONLYDIR);
                foreach ($folders as $folder) {
                    $folder_name = basename($folder);
                    if (is_numeric(str_replace('-', '', $folder_name))) {
                        $folders_list[] = $folder_name;
                    }
                }
            }
            
            if (empty($folders_list)) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ هیچ پورت حذف شده‌ای برای تمدید وجود ندارد."
                ]);
                exit;
            }
            
            $keyboard = ['inline_keyboard' => []];
            foreach ($folders_list as $folder) {
                $keyboard['inline_keyboard'][] = [
                    ['text' => "📁 $folder", 'callback_data' => "renew_folder_$folder"]
                ];
            }
            $keyboard['inline_keyboard'][] = [
                ['text' => "🔙 بازگشت", 'callback_data' => "main_menu"]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📋 لیست پورت‌های حذف شده:\nلطفاً پورتی که می‌خواهید تمدید و بازیابی کنید را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        elseif ($data == 'update_bot') {
            // نمایش لیست پوشه‌ها برای آپدیت
            $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
            $folders_list = [];
            
            foreach ($folders as $folder) {
                $folder_name = basename($folder);
                if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
                    $folders_list[] = $folder_name;
                }
            }
            
            if (empty($folders_list)) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ هیچ پورتی برای آپدیت وجود ندارد."
                ]);
                exit;
            }
            
            $keyboard = ['inline_keyboard' => []];
            foreach ($folders_list as $folder) {
                $keyboard['inline_keyboard'][] = [
                    ['text' => "📁 $folder", 'callback_data' => "select_folder_$folder"]
                ];
            }
            $keyboard['inline_keyboard'][] = [
                ['text' => "🔙 بازگشت", 'callback_data' => "main_menu"]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📋 لیست پورت‌ها:\nلطفاً پورتی که می‌خواهید فایل‌های آن را مشاهده کنید را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // اضافه کردن دکمه آپدیت زمان‌ها
        elseif ($data == 'update_times') {
            $result = updateAllPortsTo30Days();
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "✅ به‌روزرسانی زمان‌ها با موفقیت انجام شد!\n\n📊 نتایج:\n• تعداد پورت‌ها: {$result['total']}\n• موفق: {$result['success']}\n• ناموفق: " . ($result['total'] - $result['success'])
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // اضافه کردن دکمه آپدیت توکن‌ها
        elseif ($data == 'update_tokens') {
            $step_file = __DIR__ . "/step_$chat_id.txt";
            file_put_contents($step_file, "await_token_all");
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "لطفاً توکن جدید را برای همه پورت‌ها ارسال کنید:"
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // اضافه کردن دکمه افزودن فایل جدید
        elseif ($data == 'add_new_file') {
            $step_file = __DIR__ . "/step_$chat_id.txt";
            file_put_contents($step_file, "await_new_file");
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📁 افزودن فایل جدید\n\nلطفاً فایل جدید را به صورت فایل (document) ارسال کنید. این فایل به تمام پورت‌ها اضافه خواهد شد."
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        elseif ($data == 'main_menu') {
            // بازگشت به منوی اصلی
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => 'ساخت ربات جدید', 'callback_data' => 'create_new_bot']],
                    [['text' => 'حذف پورت', 'callback_data' => 'delete_bot']],
                    [['text' => 'تمدید پورت', 'callback_data' => 'renew_bot']],
                    [['text' => 'آپدیت پورت‌ها', 'callback_data' => 'update_bot']],
                    [['text' => 'آپدیت زمان‌ها', 'callback_data' => 'update_times']],
                    [['text' => 'آپدیت توکن‌ها', 'callback_data' => 'update_tokens']],
                    [['text' => 'افزودن فایل جدید', 'callback_data' => 'add_new_file']] // دکمه جدید
                ]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "👋 ادمین گرامی خوش آمدید!\nلطفاً یکی از گزینه‌ها را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // مدیریت حذف پوشه‌ها
        elseif (strpos($data, 'delete_folder_') === 0) {
            $folder_name = str_replace('delete_folder_', '', $data);
            $folder_path = __DIR__ . "/$folder_name";
            
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ حذف', 'callback_data' => "confirm_delete_$folder_name"],
                        ['text' => '❌ لغو', 'callback_data' => "cancel_delete_$folder_name"]
                    ],
                    [
                        ['text' => '🔙 بازگشت', 'callback_data' => 'delete_bot']
                    ]
                ]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "⚠️ آیا مطمئن هستید که می‌خواهید پورت '$folder_name' را حذف کنید؟\n\n📝 توجه: پورت به پوشه deleted_ports منتقل می‌شود و قابل بازیابی است.",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // تأیید حذف پوشه
        elseif (strpos($data, 'confirm_delete_') === 0) {
            $folder_name = str_replace('confirm_delete_', '', $data);
            $folder_path = __DIR__ . "/$folder_name";
            $deleted_path = __DIR__ . "/deleted_ports/$folder_name";
            
            if (file_exists($folder_path)) {
                // انتقال پوشه به deleted_ports
                if (moveFolder($folder_path, $deleted_path)) {
                    bot('editMessageText', [
                        'chat_id' => $chat_id,
                        'message_id' => $message_id,
                        'text' => "✅ پورت '$folder_name' با موفقیت حذف و به آرشیو منتقل شد."
                    ]);
                } else {
                    bot('editMessageText', [
                        'chat_id' => $chat_id,
                        'message_id' => $message_id,
                        'text' => "❌ خطا در حذف پورت '$folder_name'."
                    ]);
                }
            } else {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ پورت '$folder_name' یافت نشد."
                ]);
            }
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // لغو حذف پوشه
        elseif (strpos($data, 'cancel_delete_') === 0) {
            $folder_name = str_replace('cancel_delete_', '', $data);
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "❌ حذف پورت '$folder_name' لغو شد."
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // مدیریت تمدید پوشه‌ها
        elseif (strpos($data, 'renew_folder_') === 0) {
            $folder_name = str_replace('renew_folder_', '', $data);
            $step_file = __DIR__ . "/step_$chat_id.txt";
            
            // ذخیره اطلاعات پوشه برای مرحله بعد
            file_put_contents($step_file, "await_renew_days:$folder_name");
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "لطفاً تعداد روزهای تمدید برای پورت '$folder_name' را ارسال کنید:"
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // انتخاب پوشه برای آپدیت
        elseif (strpos($data, 'select_folder_') === 0) {
            $folder_name = str_replace('select_folder_', '', $data);
            $folder_path = __DIR__ . "/$folder_name";
            
            if (!file_exists($folder_path)) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ پورت '$folder_name' یافت نشد."
                ]);
                exit;
            }
            
            // لیست فایل‌های PHP در پوشه
            $files = glob($folder_path . "/*.php");
            $files_list = [];
            
            foreach ($files as $file) {
                $file_name = basename($file);
                $files_list[] = $file_name;
            }
            
            if (empty($files_list)) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ هیچ فایل PHP در پورت '$folder_name' یافت نشد."
                ]);
                exit;
            }
            
            $keyboard = ['inline_keyboard' => []];
            foreach ($files_list as $file) {
                $keyboard['inline_keyboard'][] = [
                    ['text' => "📄 $file", 'callback_data' => "select_file_$file"]
                ];
            }
            $keyboard['inline_keyboard'][] = [
                ['text' => "🔙 بازگشت", 'callback_data' => "update_bot"]
            ];
            
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📋 فایل‌های پورت '$folder_name':\nلطفاً فایلی که می‌خواهید آپدیت کنید را انتخاب کنید:",
                'reply_markup' => json_encode($keyboard)
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
        // انتخاب فایل برای آپدیت
        elseif (strpos($data, 'select_file_') === 0) {
            $file_name = str_replace('select_file_', '', $data);
            $step_file = __DIR__ . "/step_$chat_id.txt";
            
            // ذخیره اطلاعات فایل برای مرحله بعد
            file_put_contents($step_file, "await_update_file:$file_name");
            
            // ایجاد پوشه kon اگر وجود ندارد
            $kon_dir = __DIR__ . "/kon";
            if (!file_exists($kon_dir)) {
                mkdir($kon_dir, 0777, true);
            }
            
            // جمع‌آوری فایل‌ها از تمام پوشه‌ها
            $folders = glob(__DIR__ . '/*', GLOB_ONLYDIR);
            $collected_count = 0;
            
            foreach ($folders as $folder) {
                $folder_name = basename($folder);
                if (!in_array($folder_name, SYSTEM_FOLDERS) && is_numeric(str_replace('-', '', $folder_name))) {
                    $source_file = $folder . '/' . $file_name;
                    if (file_exists($source_file)) {
                        $target_file = $kon_dir . '/' . $folder_name . '_' . $file_name;
                        if (copy($source_file, $target_file)) {
                            $collected_count++;
                        }
                    }
                }
            }
            
            if ($collected_count > 0) {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "✅ $collected_count کپی از فایل '$file_name' جمع‌آوری شد.\n\nلطفاً فایل جدید '$file_name' را ارسال کنید:"
                ]);
            } else {
                bot('editMessageText', [
                    'chat_id' => $chat_id,
                    'message_id' => $message_id,
                    'text' => "❌ هیچ فایلی با نام '$file_name' در پورت‌ها یافت نشد."
                ]);
                unlink($step_file);
            }
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id']
            ]);
            exit;
        }
    }
}

$message = $update['message'] ?? null;
$chat_id = $message['chat']['id'] ?? null;
$text = trim($message['text'] ?? '');
$document = $message['document'] ?? null;

// بررسی اینکه آیا کاربر ادمین است
if (in_array($chat_id, ADMIN_IDS)) {
    if ($text == "/start") {
        $keyboard = [
            'inline_keyboard' => [
                [['text' => 'ساخت ربات جدید', 'callback_data' => 'create_new_bot']],
                [['text' => 'حذف پورت', 'callback_data' => 'delete_bot']],
                [['text' => 'تمدید پورت', 'callback_data' => 'renew_bot']],
                [['text' => 'آپدیت پورت‌ها', 'callback_data' => 'update_bot']],
                [['text' => 'آپدیت زمان‌ها', 'callback_data' => 'update_times']],
                [['text' => 'آپدیت توکن‌ها', 'callback_data' => 'update_tokens']],
                [['text' => 'افزودن فایل جدید', 'callback_data' => 'add_new_file']] // دکمه جدید
            ]
        ];
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "👋 ادمین گرامی خوش آمدید!\nلطفاً یکی از گزینه‌ها را انتخاب کنید:",
            'reply_markup' => json_encode($keyboard)
        ]);
        exit;
    }

    $step_file = __DIR__ . "/step_$chat_id.txt";
    $user_step = file_exists($step_file) ? trim(file_get_contents($step_file)) : "none";

    if ($user_step == "await_token") {
        if (empty($text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "لطفاً یک توکن معتبر ارسال کنید."
            ]);
            exit;
        }

        // اعتبارسنجی توکن
        if (!preg_match('/^[0-9]{8,10}:[a-zA-Z0-9_-]{35}$/', $text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⚠️ فرمت توکن نامعتبر است! لطفاً توکن را به صورت صحیح وارد کنید."
            ]);
            exit;
        }

        file_put_contents("token_$chat_id.txt", $text);
        file_put_contents($step_file, "await_id");
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ توکن دریافت شد.\nلطفاً آیدی عددی (یا آیدی گروه با منفی) را ارسال کنید:"
        ]);
        exit;
    }

    if ($user_step == "await_id") {
        if (empty($text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "لطفاً یک آیدی معتبر ارسال کنید."
            ]);
            exit;
        }

        // اعتبارسنجی آیدی
        if (!preg_match('/^-?[0-9]+$/', $text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⚠️ فرمت آیدی نامعتبر است! لطفاً فقط عدد وارد کنید."
            ]);
            exit;
        }

        file_put_contents("id_$chat_id.txt", $text);
        file_put_contents($step_file, "await_days");
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ آیدی دریافت شد.\nلطفاً تعداد روزهای سرویس را ارسال کنید:"
        ]);
        exit;
    }

    if ($user_step == "await_days") {
        if (empty($text) || !is_numeric($text) || $text < 1) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "لطفاً یک عدد معتبر برای روزهای سرویس ارسال کنید (حداقل 1 روز)."
            ]);
            exit;
        }

        $token = file_get_contents("token_$chat_id.txt");
        $id = file_get_contents("id_$chat_id.txt");
        $days = intval($text);
        $folder_name = preg_replace('/[^0-9-]/', '', $id); // پاکسازی نام پوشه

        function fullCopy($source, $target) {
            if (is_dir($source)) {
                @mkdir($target, 0777, true);
                $dir = opendir($source);
                while (($file = readdir($dir)) !== false) {
                    if ($file != "." && $file != "..") {
                        $src = $source . "/" . $file;
                        $dst = $target . "/" . $file;
                        if (is_dir($src)) {
                            fullCopy($src, $dst);
                        } else {
                            copy($src, $dst);
                        }
                    }
                }
                closedir($dir);
            }
        }

        $source_dir = __DIR__ . "/SaEeDRat";
        $target_dir = __DIR__ . "/$folder_name";
        
        if (!file_exists($source_dir)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "❌ پوشه منبع یافت نشد!"
            ]);
            exit;
        }

        fullCopy($source_dir, $target_dir);

        $chal_file = "$target_dir/chalim.php";
        if (file_exists($chal_file)) {
            $code = file_get_contents($chal_file);
            
            // ویرایش توکن
            $code = preg_replace('/\$bot_token\s*=\s*".*?";/', '$bot_token = "' . $token . '";', $code);
            
            // ویرایش sudo_port
            $code = preg_replace('/\$sudo_port\s*=\s*".*?";/', '$sudo_port = "' . $id . '";', $code);
            
            // ویرایش sudo_user
            $code = preg_replace('/\$sudo_user\s*=\s*\[.*?\];/', '$sudo_user = ["' . $id . '"];', $code);
            
            // ویرایش id_sender
            $code = preg_replace('/\$id_sender\s*=\s*".*?";/', '$id_sender = "' . $id . '";', $code);
            
            // ویرایش days_remaining
            $code = preg_replace('/\$days_remaining\s*=\s*\d+;/', '$days_remaining = ' . $days . ';', $code);
            
            file_put_contents($chal_file, $code);
        }

        // ایجاد فایل time_data.json با اطلاعات روزها
        $time_data_dir = "$target_dir/data";
        if (!file_exists($time_data_dir)) {
            mkdir($time_data_dir, 0777, true);
        }
        
        $current_date = date('Y/m/d');
        $expiry_date = date('Y/m/d', strtotime("+$days days"));
        
        $time_data = [
            'purchase_date' => $current_date,
            'expiry_date' => $expiry_date,
            'days_remaining' => $days,
            'last_update' => $current_date
        ];
        
        file_put_contents("$time_data_dir/time_data.json", json_encode($time_data));

        $panel_url = "https://Henry.iran-net.sbs/amir/$folder_name/panel.php";
        
        // تنظیم وب‌هوک
        $webhook_result = file_get_contents("https://api.telegram.org/bot$token/setWebhook?url=$panel_url");
        
        // حذف فایل‌های موقت
        unlink($step_file);
        unlink("token_$chat_id.txt");
        unlink("id_$chat_id.txt");

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ ربات با موفقیت ساخته شد!\n\n🔗 آدرس پنل:\n$panel_url\n📅 مدت سرویس: $days روز\n\n📌 اطلاعات وب‌هوک:\n" . json_encode(json_decode($webhook_result), JSON_PRETTY_PRINT),
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    }

    // مدیریت تمدید پورت
    if (strpos($user_step, "await_renew_days:") === 0) {
        $parts = explode(":", $user_step);
        $folder_name = $parts[1];
        
        if (empty($text) || !is_numeric($text) || $text < 1) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "لطفاً یک عدد معتبر برای روزهای تمدید ارسال کنید (حداقل 1 روز)."
            ]);
            exit;
        }

        $days = intval($text);
        $source_dir = __DIR__ . "/deleted_ports/$folder_name";
        $target_dir = __DIR__ . "/$folder_name";
        
        if (!file_exists($source_dir)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "❌ پورت '$folder_name' در آرشیو یافت نشد!"
            ]);
            unlink($step_file);
            exit;
        }

        // بازیابی پوشه از آرشیو
        if (!restoreFolder($source_dir, $target_dir)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "❌ خطا در بازیابی پورت '$folder_name'."
            ]);
            unlink($step_file);
            exit;
        }

        // به روزرسانی فایل chalim.php
        $chal_file = "$target_dir/chalim.php";
        if (file_exists($chal_file)) {
            $code = file_get_contents($chal_file);
            
            // ویرایش days_remaining
            $code = preg_replace('/\$days_remaining\s*=\s*\d+;/', '$days_remaining = ' . $days . ';', $code);
            
            file_put_contents($chal_file, $code);
        }

        // حذف و ایجاد مجدد فایل time_data.json
        $time_data_dir = "$target_dir/data";
        $time_data_file = "$time_data_dir/time_data.json";
        
        if (file_exists($time_data_file)) {
            unlink($time_data_file);
        }
        
        if (!file_exists($time_data_dir)) {
            mkdir($time_data_dir, 0777, true);
        }
        
        $current_date = date('Y/m/d');
        $expiry_date = date('Y/m/d', strtotime("+$days days"));
        
        $time_data = [
            'purchase_date' => $current_date,
            'expiry_date' => $expiry_date,
            'days_remaining' => $days,
            'last_update' => $current_date
        ];
        
        file_put_contents($time_data_file, json_encode($time_data));

        // حذف فایل step
        unlink($step_file);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پورت '$folder_name' با موفقیت تمدید و بازیابی شد!\n\n📅 مدت سرویس جدید: $days روز"
        ]);
    }

    // مدیریت آپدیت فایل
    if (strpos($user_step, "await_update_file:") === 0) {
        $parts = explode(":", $user_step);
        $file_name = $parts[1];
        
        if ($document) {
            // دریافت فایل
            $file_id = $document['file_id'];
            $file_info = bot('getFile', ['file_id' => $file_id]);
            $file_path = $file_info['result']['file_path'];
            $file_url = "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $file_path;
            
            // دانلود فایل
            $temp_file = __DIR__ . "/temp_" . $file_name;
            file_put_contents($temp_file, file_get_contents($file_url));
            
            // کپی فایل به تمام پوشه‌ها
            $result = copyFileToAllFolders($temp_file, $file_name);
            
            // حذف فایل موقت
            unlink($temp_file);
            unlink($step_file);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "✅ فایل '$file_name' با موفقیت آپدیت شد!\n\n📊 نتایج:\n• تعداد پورت‌ها: {$result['total']}\n• موفق: {$result['success']}\n• ناموفق: " . ($result['total'] - $result['success'])
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "❌ لطفاً فایل را به صورت document ارسال کنید."
            ]);
        }
        exit;
    }

    // مدیریت آپدیت توکن همه پورت‌ها
    if ($user_step == "await_token_all") {
        if (empty($text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "لطفاً یک توکن معتبر ارسال کنید."
            ]);
            exit;
        }

        // اعتبارسنجی توکن
        if (!preg_match('/^[0-9]{8,10}:[a-zA-Z0-9_-]{35}$/', $text)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⚠️ فرمت توکن نامعتبر است! لطفاً توکن را به صورت صحیح وارد کنید."
            ]);
            exit;
        }

        $result = updateAllTokens($text);
        
        // حذف فایل step
        unlink($step_file);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ توکن همه پورت‌ها با موفقیت آپدیت شد!\n\n📊 نتایج:\n• تعداد پورت‌ها: {$result['total']}\n• موفق: {$result['success']}\n• ناموفق: " . ($result['total'] - $result['success'])
        ]);
        exit;
    }

    // مدیریت افزودن فایل جدید
    if ($user_step == "await_new_file") {
        if ($document) {
            // دریافت فایل
            $file_id = $document['file_id'];
            $file_info = bot('getFile', ['file_id' => $file_id]);
            $file_path = $file_info['result']['file_path'];
            $file_url = "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $file_path;
            
            // دریافت نام فایل اصلی
            $original_filename = $document['file_name'];
            
            // دانلود فایل
            $temp_file = __DIR__ . "/temp_" . $original_filename;
            file_put_contents($temp_file, file_get_contents($file_url));
            
            // کپی فایل به تمام پوشه‌ها
            $result = addNewFileToAllFolders($temp_file, $original_filename);
            
            // حذف فایل موقت
            unlink($temp_file);
            unlink($step_file);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "✅ فایل '$original_filename' با موفقیت به تمام پورت‌ها اضافه شد!\n\n📊 نتایج:\n• تعداد پورت‌ها: {$result['total']}\n• موفق: {$result['success']}\n• ناموفق: " . ($result['total'] - $result['success'])
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "❌ لطفاً فایل را به صورت document ارسال کنید."
            ]);
        }
        exit;
    }
}
?>
[file content end]